/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xbib.net.path.spring.PathContainer;
import org.xbib.net.path.spring.PathMatchInfo;
import org.xbib.net.path.spring.PathPattern;
import org.xbib.net.path.spring.util.MultiValueMap;

public class MatchingContext {
    private final PathPattern pathPattern;
    public final PathContainer candidate;
    public final List<PathContainer.Element> pathElements;
    public final int pathLength;
    private Map<String, String> extractedUriVariables;
    private Map<String, MultiValueMap<String, String>> extractedMatrixVariables;
    public boolean extractingVariables;
    public boolean determineRemainingPath = false;
    public int remainingPathIndex;

    public MatchingContext(PathPattern pathPattern, PathContainer pathContainer, boolean extractVariables) {
        this.pathPattern = pathPattern;
        this.candidate = pathContainer;
        this.pathElements = pathContainer.elements();
        this.pathLength = this.pathElements.size();
        this.extractingVariables = extractVariables;
    }

    public void setMatchAllowExtraPath() {
        this.determineRemainingPath = true;
    }

    public boolean isMatchOptionalTrailingSeparator() {
        return this.pathPattern.matchOptionalTrailingSeparator;
    }

    public void set(String key, String value, MultiValueMap<String, String> parameters) {
        if (this.extractedUriVariables == null) {
            this.extractedUriVariables = new HashMap<String, String>();
        }
        this.extractedUriVariables.put(key, value);
        if (!parameters.isEmpty()) {
            if (this.extractedMatrixVariables == null) {
                this.extractedMatrixVariables = new HashMap<String, MultiValueMap<String, String>>();
            }
            this.extractedMatrixVariables.put(key, parameters);
        }
    }

    public PathMatchInfo getPathMatchResult() {
        if (this.extractedUriVariables == null) {
            return PathMatchInfo.EMPTY;
        }
        return new PathMatchInfo(this.extractedUriVariables, this.extractedMatrixVariables);
    }

    public boolean isSeparator(int pathIndex) {
        return this.pathElements.get(pathIndex) instanceof PathContainer.Separator;
    }

    public String pathElementValue(int pathIndex) {
        PathContainer.Element element;
        PathContainer.Element element2 = element = pathIndex < this.pathLength ? this.pathElements.get(pathIndex) : null;
        if (element instanceof PathContainer.PathSegment) {
            PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
            return pathSegment.valueToMatch();
        }
        return "";
    }
}

