/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.spring;

import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import org.xbib.net.path.spring.MatchingContext;
import org.xbib.net.path.spring.PathContainer;
import org.xbib.net.path.spring.PathMatchInfo;
import org.xbib.net.path.spring.PathPatternParser;
import org.xbib.net.path.spring.PathRemainingMatchInfo;
import org.xbib.net.path.spring.element.CaptureTheRestPathElement;
import org.xbib.net.path.spring.element.PathElement;
import org.xbib.net.path.spring.element.SeparatorPathElement;
import org.xbib.net.path.spring.element.WildcardPathElement;
import org.xbib.net.path.spring.element.WildcardTheRestPathElement;

public class PathPattern
implements Comparable<PathPattern> {
    private static final PathContainer EMPTY_PATH = PathContainer.parsePath("");
    public static final Comparator<PathPattern> SPECIFICITY_COMPARATOR = Comparator.nullsLast(Comparator.comparingInt(p -> p.isCatchAll() ? 1 : 0).thenComparingInt(p -> p.isCatchAll() ? PathPattern.scoreByNormalizedLength(p) : 0).thenComparingInt(PathPattern::getScore).thenComparingInt(PathPattern::scoreByNormalizedLength));
    private final String patternString;
    private final PathPatternParser parser;
    private final PathContainer.Options pathOptions;
    final boolean matchOptionalTrailingSeparator;
    private final boolean caseSensitive;
    private final PathElement head;
    private int capturedVariableCount;
    private int normalizedLength;
    private boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean catchAll = false;

    public PathPattern(String patternText, PathPatternParser parser, PathElement head) {
        this.patternString = patternText;
        this.parser = parser;
        this.pathOptions = parser.getPathOptions();
        this.matchOptionalTrailingSeparator = parser.isMatchOptionalTrailingSeparator();
        this.caseSensitive = parser.isCaseSensitive();
        this.head = head;
        PathElement elem = head;
        while (elem != null) {
            this.capturedVariableCount += elem.getCaptureCount();
            this.normalizedLength += elem.getNormalizedLength();
            this.score += elem.getScore();
            if (elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                this.catchAll = true;
            }
            if (elem instanceof SeparatorPathElement && elem.next instanceof WildcardPathElement && elem.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            elem = elem.next;
        }
    }

    public String getPatternString() {
        return this.patternString;
    }

    public boolean hasPatternSyntax() {
        return this.score > 0 || this.catchAll || this.patternString.indexOf(63) != -1;
    }

    public boolean matches(PathContainer pathContainer) {
        if (this.head == null) {
            return !this.hasLength(pathContainer) || this.matchOptionalTrailingSeparator && this.pathContainerIsJustSeparator(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(this, pathContainer, false);
        return this.head.matches(0, matchingContext);
    }

    public PathMatchInfo matchAndExtract(PathContainer pathContainer) {
        MatchingContext matchingContext;
        if (this.head == null) {
            return this.hasLength(pathContainer) && (!this.matchOptionalTrailingSeparator || !this.pathContainerIsJustSeparator(pathContainer)) ? null : PathMatchInfo.EMPTY;
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return null;
            }
        }
        return this.head.matches(0, matchingContext = new MatchingContext(this, pathContainer, true)) ? matchingContext.getPathMatchResult() : null;
    }

    public PathRemainingMatchInfo matchStartOfPath(PathContainer pathContainer) {
        PathContainer pathRemaining;
        PathContainer pathMatched;
        if (this.head == null) {
            return new PathRemainingMatchInfo(EMPTY_PATH, pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            return null;
        }
        MatchingContext matchingContext = new MatchingContext(this, pathContainer, true);
        matchingContext.setMatchAllowExtraPath();
        boolean matches = this.head.matches(0, matchingContext);
        if (!matches) {
            return null;
        }
        if (matchingContext.remainingPathIndex == pathContainer.elements().size()) {
            pathMatched = pathContainer;
            pathRemaining = EMPTY_PATH;
        } else {
            pathMatched = pathContainer.subPath(0, matchingContext.remainingPathIndex);
            pathRemaining = pathContainer.subPath(matchingContext.remainingPathIndex);
        }
        return new PathRemainingMatchInfo(pathMatched, pathRemaining, matchingContext.getPathMatchResult());
    }

    public PathContainer extractPathWithinPattern(PathContainer path) {
        int endIndex;
        List<PathContainer.Element> pathElements = path.elements();
        int pathElementsCount = pathElements.size();
        int startIndex = 0;
        PathElement elem = this.head;
        while (elem != null && elem.getWildcardCount() == 0 && elem.getCaptureCount() == 0) {
            elem = elem.next;
            ++startIndex;
        }
        if (elem == null) {
            return PathContainer.parsePath("");
        }
        while (startIndex < pathElementsCount && pathElements.get(startIndex) instanceof PathContainer.Separator) {
            ++startIndex;
        }
        for (endIndex = pathElements.size(); endIndex > 0 && pathElements.get(endIndex - 1) instanceof PathContainer.Separator; --endIndex) {
        }
        boolean multipleAdjacentSeparators = false;
        for (int i = startIndex; i < endIndex - 1; ++i) {
            if (!(pathElements.get(i) instanceof PathContainer.Separator) || !(pathElements.get(i + 1) instanceof PathContainer.Separator)) continue;
            multipleAdjacentSeparators = true;
            break;
        }
        PathContainer resultPath = null;
        if (multipleAdjacentSeparators) {
            StringBuilder sb = new StringBuilder();
            int i = startIndex;
            while (i < endIndex) {
                PathContainer.Element e = pathElements.get(i++);
                sb.append(e.value());
                if (!(e instanceof PathContainer.Separator)) continue;
                while (i < endIndex && pathElements.get(i) instanceof PathContainer.Separator) {
                    ++i;
                }
            }
            resultPath = PathContainer.parsePath(sb.toString(), this.pathOptions);
        } else {
            resultPath = startIndex >= endIndex ? PathContainer.parsePath("") : path.subPath(startIndex, endIndex);
        }
        return resultPath;
    }

    @Override
    public int compareTo(PathPattern otherPattern) {
        int result = SPECIFICITY_COMPARATOR.compare(this, otherPattern);
        return result == 0 && otherPattern != null ? this.patternString.compareTo(otherPattern.patternString) : result;
    }

    public PathPattern combine(PathPattern pattern2string) {
        boolean secondExtensionWild;
        if (!PathPattern.hasLength(this.patternString)) {
            if (!PathPattern.hasLength(pattern2string.patternString)) {
                return this.parser.parse("");
            }
            return pattern2string;
        }
        if (!PathPattern.hasLength(pattern2string.patternString)) {
            return this;
        }
        if (!this.patternString.equals(pattern2string.patternString) && this.capturedVariableCount == 0 && this.matches(PathContainer.parsePath(pattern2string.patternString))) {
            return pattern2string;
        }
        if (this.endsWithSeparatorWildcard) {
            return this.parser.parse(this.concat(this.patternString.substring(0, this.patternString.length() - 2), pattern2string.patternString));
        }
        int starDotPos1 = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || starDotPos1 == -1 || this.getSeparator() == '.') {
            return this.parser.parse(this.concat(this.patternString, pattern2string.patternString));
        }
        String firstExtension = this.patternString.substring(starDotPos1 + 1);
        String p2string = pattern2string.patternString;
        int dotPos2 = p2string.indexOf(46);
        String file2 = dotPos2 == -1 ? p2string : p2string.substring(0, dotPos2);
        String secondExtension = dotPos2 == -1 ? "" : p2string.substring(dotPos2);
        boolean firstExtensionWild = firstExtension.equals(".*") || firstExtension.isEmpty();
        boolean bl = secondExtensionWild = secondExtension.equals(".*") || secondExtension.isEmpty();
        if (!firstExtensionWild && !secondExtensionWild) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + String.valueOf(pattern2string));
        }
        return this.parser.parse(file2 + (firstExtensionWild ? secondExtension : firstExtension));
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PathPattern)) {
            return false;
        }
        PathPattern otherPattern = (PathPattern)other;
        return this.patternString.equals(otherPattern.getPatternString()) && this.getSeparator() == otherPattern.getSeparator() && this.caseSensitive == otherPattern.caseSensitive;
    }

    public int hashCode() {
        return (this.patternString.hashCode() + this.getSeparator()) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toString() {
        return this.patternString;
    }

    int getScore() {
        return this.score;
    }

    boolean isCatchAll() {
        return this.catchAll;
    }

    int getNormalizedLength() {
        return this.normalizedLength;
    }

    char getSeparator() {
        return this.pathOptions.separator();
    }

    int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    String toChainString() {
        StringJoiner stringJoiner = new StringJoiner(" ");
        PathElement pe = this.head;
        while (pe != null) {
            stringJoiner.add(pe.toString());
            pe = pe.next;
        }
        return stringJoiner.toString();
    }

    String computePatternString() {
        StringBuilder sb = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            sb.append(pe.getChars());
            pe = pe.next;
        }
        return sb.toString();
    }

    PathElement getHeadSection() {
        return this.head;
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.getSeparator();
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.getSeparator();
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.getSeparator() + path2;
    }

    private boolean hasLength(PathContainer container) {
        return container != null && container.elements().size() > 0;
    }

    private static int scoreByNormalizedLength(PathPattern pattern) {
        return -pattern.getNormalizedLength();
    }

    private boolean pathContainerIsJustSeparator(PathContainer pathContainer) {
        return pathContainer.value().length() == 1 && pathContainer.value().charAt(0) == this.getSeparator();
    }
}

