/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.xbib.net.PathNormalizer;
import org.xbib.net.path.structure.PathSegment;

public class Path {
    protected static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{[^/]+?}");
    protected static final String CATCH_ALL = "**";
    protected String pathSpec;
    protected String pathSeparator;
    protected boolean trimTokens;
    protected boolean caseSensitive;
    protected List<PathSegment> segments;
    private int parameterCount;
    private int singleWildcards;
    private int doubleWildcards;
    private boolean catchAllPattern;
    private boolean prefixPattern;
    private Integer length;

    public Path() {
    }

    public Path(String pathSpec) {
        this(pathSpec, "/", false, false);
    }

    public Path(String pathSpec, String pathSeparator, boolean trimTokens, boolean caseSensitive) {
        this.init(pathSpec, pathSeparator, trimTokens, caseSensitive);
    }

    public static Path of(String pathSpec) {
        return new Path(pathSpec);
    }

    protected final void init(String pathSpec, String pathSeparator, boolean trimTokens, boolean caseSensitive) {
        this.pathSpec = PathNormalizer.normalize((String)pathSpec);
        this.pathSeparator = pathSeparator;
        this.trimTokens = trimTokens;
        this.caseSensitive = caseSensitive;
        this.segments = this.tokenize(this.pathSpec);
        if (pathSpec != null) {
            this.initCounters();
            this.catchAllPattern = pathSpec.equals(CATCH_ALL);
            boolean bl = this.prefixPattern = !this.catchAllPattern && pathSpec.endsWith(CATCH_ALL);
        }
        if (this.parameterCount == 0) {
            this.length = pathSpec != null ? pathSpec.length() : 0;
        }
    }

    public String getPathSpec() {
        return this.pathSpec;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public boolean isTrimTokens() {
        return this.trimTokens;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public int getSingleWildcards() {
        return this.singleWildcards;
    }

    public int getDoubleWildcards() {
        return this.doubleWildcards;
    }

    public boolean isLeastSpecific() {
        return this.pathSpec == null || this.catchAllPattern;
    }

    public boolean isPrefixPattern() {
        return this.prefixPattern;
    }

    public int getTotalCount() {
        return this.parameterCount + this.singleWildcards + 2 * this.doubleWildcards;
    }

    public boolean isCatchAllPattern() {
        return this.catchAllPattern;
    }

    public boolean isWildCard() {
        return this.singleWildcards > 0 || this.doubleWildcards > 0;
    }

    public int getLength() {
        if (this.length == null) {
            this.length = PARAMETER_PATTERN.matcher(this.pathSpec).replaceAll("#").length();
        }
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path that = (Path)o;
        return this.parameterCount == that.parameterCount && this.singleWildcards == that.singleWildcards && this.doubleWildcards == that.doubleWildcards && this.catchAllPattern == that.catchAllPattern && this.prefixPattern == that.prefixPattern && Objects.equals(this.pathSpec, that.pathSpec) && Objects.equals(this.length, that.length);
    }

    public int hashCode() {
        return Objects.hash(this.pathSpec, this.parameterCount, this.singleWildcards, this.doubleWildcards, this.catchAllPattern, this.prefixPattern, this.length);
    }

    protected final List<PathSegment> tokenize(String string) {
        return Path.tokenize(string, this.pathSeparator, this.trimTokens, this.caseSensitive);
    }

    protected static List<PathSegment> tokenize(String string, String pathSeparator, boolean trimTokens, boolean caseSensitive) {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        if (string == null) {
            return pathSegments;
        }
        StringTokenizer st = new StringTokenizer(string, pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (token.isEmpty()) continue;
            if (!caseSensitive) {
                token = token.toLowerCase(Locale.ROOT);
            }
            PathSegment pathSegment = new PathSegment();
            pathSegment.setString(token);
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }

    private void initCounters() {
        this.singleWildcards = 0;
        this.doubleWildcards = 0;
        int pos = 0;
        while (pos < this.pathSpec.length()) {
            char ch = this.pathSpec.charAt(pos);
            if (ch == '{') {
                ++this.parameterCount;
                ++pos;
                continue;
            }
            if (ch == '*') {
                if (pos + 1 < this.pathSpec.length() && this.pathSpec.charAt(pos + 1) == '*') {
                    ++this.doubleWildcards;
                    pos += 2;
                    continue;
                }
                if (pos > 0 && (this.pathSpec.charAt(pos - 1) != '.' || this.pathSpec.charAt(pos) != '*')) {
                    ++this.singleWildcards;
                    ++pos;
                    continue;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
    }
}

