/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbib.net.Parameter;
import org.xbib.net.ParameterBuilder;
import org.xbib.net.PathNormalizer;
import org.xbib.net.path.structure.Path;
import org.xbib.net.path.structure.PathSegment;
import org.xbib.net.util.CharMatcher;

public class PathMatcher
extends Path {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*\\*|\\*|\\{((?:\\{[^/]+?}|[^/{}]|\\\\[{}])+?)}");
    private static final Pattern MATCH_ALL_PATTERN = Pattern.compile("(.*)");
    private static final CharMatcher RESERVED_URL_CHARS = CharMatcher.anyOf((CharSequence)":/?#[]{}");
    private static final String DEFAULT_PATTERN = "(.*)";
    private static final String WILDCARD = "*";
    private final boolean fullMatch;
    private List<PathSegment> analyzedSegments = this.analyzeTokens();
    private final ParameterBuilder parameterBuilder;

    public PathMatcher() {
        this(null, "/", true, true, true, Parameter.builder().domain(Parameter.Domain.PATH).enableSort());
    }

    public PathMatcher(String pathSpec, String pathSeparator, boolean trimTokens, boolean caseSensitive, boolean fullMatch, ParameterBuilder parameterBuilder) {
        super.init(pathSpec, pathSeparator, trimTokens, caseSensitive);
        this.fullMatch = fullMatch;
        this.parameterBuilder = parameterBuilder;
    }

    public static PathMatcher of(String pathSpec) {
        return new PathMatcher(pathSpec, "/", true, true, true, Parameter.builder().domain(Parameter.Domain.PATH).enableSort());
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public Parameter getParameter() {
        return this.parameterBuilder.build();
    }

    public List<PathSegment> getAnalyzedSegments() {
        return this.analyzedSegments;
    }

    public boolean match(String pathSpec, String path) {
        super.init(pathSpec, this.pathSeparator, this.trimTokens, this.caseSensitive);
        this.analyzedSegments = this.analyzeTokens();
        return this.match(path);
    }

    public boolean match(String path) {
        boolean b;
        PathSegment pathSegment;
        int pathStart;
        String normalizedPath = PathNormalizer.normalize((String)path);
        if (normalizedPath.startsWith(this.pathSeparator) != this.pathSpec.startsWith(this.pathSeparator)) {
            return false;
        }
        List<PathSegment> analyzedSegments = this.getAnalyzedSegments();
        List<PathSegment> pathSegments = this.tokenize(normalizedPath);
        int patternStart = 0;
        int patternEnd = analyzedSegments.size() - 1;
        int pathEnd = pathSegments.size() - 1;
        for (pathStart = 0; patternStart <= patternEnd && pathStart <= pathEnd && !(pathSegment = analyzedSegments.get(patternStart)).isCatchAll(); ++patternStart, ++pathStart) {
            b = this.matchAndExtractVariables(pathSegment, pathSegments.get(pathStart));
            if (b) continue;
            return false;
        }
        if (pathStart > pathEnd) {
            if (patternStart > patternEnd) {
                return this.pathSpec.endsWith(this.pathSeparator) == normalizedPath.endsWith(this.pathSeparator);
            }
            if (!this.fullMatch) {
                return true;
            }
            if (patternStart == patternEnd && analyzedSegments.get(patternStart).getString().equals(WILDCARD) && normalizedPath.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = patternStart; i <= patternEnd; ++i) {
                if (analyzedSegments.get(i).isCatchAll()) continue;
                return false;
            }
            return true;
        }
        if (patternStart > patternEnd) {
            return false;
        }
        if (!this.fullMatch && analyzedSegments.get(patternStart).isCatchAll()) {
            return true;
        }
        while (patternStart <= patternEnd && pathStart <= pathEnd && !(pathSegment = analyzedSegments.get(patternEnd)).isCatchAll()) {
            b = this.matchAndExtractVariables(pathSegment, pathSegments.get(pathEnd));
            if (!b) {
                return false;
            }
            --patternEnd;
            --pathEnd;
        }
        if (pathStart > pathEnd) {
            for (int i = patternStart; i <= patternEnd; ++i) {
                if (analyzedSegments.get(i).isCatchAll()) continue;
                return false;
            }
            return true;
        }
        while (patternStart != patternEnd && pathStart <= pathEnd) {
            int patternIndexTemp = -1;
            for (int i = patternStart + 1; i <= patternEnd; ++i) {
                if (!analyzedSegments.get(i).isCatchAll()) continue;
                patternIndexTemp = i;
                break;
            }
            if (patternIndexTemp == patternStart + 1) {
                ++patternStart;
                continue;
            }
            int patternLength = patternIndexTemp - patternStart - 1;
            int strLength = pathEnd - pathStart + 1;
            int foundIndex = -1;
            boolean loop = true;
            block6: while (loop) {
                for (int i = 0; i <= strLength - patternLength; ++i) {
                    for (int j = 0; j < patternLength; ++j) {
                        PathSegment segment = pathSegments.get(pathStart + i + j);
                        PathSegment pathSegment2 = analyzedSegments.get(patternStart + j + 1);
                        boolean b2 = this.matchAndExtractVariables(pathSegment2, segment);
                        if (!b2) continue;
                        loop = false;
                        break;
                    }
                    if (!loop) continue block6;
                    foundIndex = pathStart + i;
                }
            }
            if (foundIndex == -1) {
                return false;
            }
            patternStart = patternIndexTemp;
            pathStart = foundIndex + patternLength;
        }
        for (int i = patternStart; i <= patternEnd; ++i) {
            if (analyzedSegments.get(i).isCatchAll()) continue;
            return false;
        }
        return true;
    }

    private boolean matchAndExtractVariables(PathSegment patternSegment, PathSegment pathSegment) {
        if (patternSegment.getPattern() == null) {
            return true;
        }
        Matcher matcher = patternSegment.getPattern().matcher(pathSegment.getString());
        if (!matcher.matches()) {
            return false;
        }
        if (patternSegment.getParameterNames() == null) {
            return true;
        }
        if (patternSegment.getParameterNames().size() != matcher.groupCount()) {
            throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + patternSegment.getString() + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String name = patternSegment.getParameterNames().get(i - 1);
            String value = matcher.group(i);
            this.parameterBuilder.add(name, (Object)value);
        }
        return true;
    }

    private List<PathSegment> analyzeTokens() {
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        for (PathSegment pathSegment : this.segments) {
            String token = pathSegment.getString();
            ArrayList<String> parameterNames = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            Matcher matcher = GLOB_PATTERN.matcher(token);
            int start = 0;
            boolean isPattern = false;
            boolean isCatchAll = false;
            while (matcher.find()) {
                sb.append(PathMatcher.quote(token, start, matcher.start()));
                String match = matcher.group();
                if ("?".equals(match)) {
                    sb.append('.');
                    isPattern = true;
                } else if (WILDCARD.equals(match)) {
                    sb.append(".*");
                    isPattern = true;
                } else if ("**".equals(match)) {
                    isCatchAll = true;
                } else if (match.startsWith("{") && match.endsWith("}")) {
                    int colonIdx = match.indexOf(58);
                    if (colonIdx == -1) {
                        sb.append(DEFAULT_PATTERN);
                        parameterNames.add(matcher.group(1));
                    } else {
                        String parameterPattern = match.substring(colonIdx + 1, match.length() - 1);
                        sb.append('(').append(parameterPattern).append(')');
                        parameterNames.add(match.substring(1, colonIdx));
                    }
                } else if (RESERVED_URL_CHARS.matchesAnyOf((CharSequence)match)) {
                    throw new IllegalArgumentException("found reserved chars in " + match);
                }
                start = matcher.end();
            }
            sb.append(PathMatcher.quote(token, start, token.length()));
            if (isPattern) {
                pathSegment.setPattern(this.caseSensitive ? Pattern.compile(sb.toString()) : Pattern.compile(sb.toString(), 2));
            }
            if (!parameterNames.isEmpty()) {
                pathSegment.setParameterNames(parameterNames);
                pathSegment.setPattern(MATCH_ALL_PATTERN);
            }
            if (isCatchAll) {
                pathSegment.setCatchAll(isCatchAll);
            }
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }

    private static String quote(String s, int start, int end) {
        return start == end ? "" : Pattern.quote(s.substring(start, end));
    }
}

