/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.net.path.structure;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.xbib.net.Parameter;
import org.xbib.net.ParameterBuilder;
import org.xbib.net.ParameterException;
import org.xbib.net.PathNormalizer;
import org.xbib.net.path.PathResolver;
import org.xbib.net.path.structure.PathMatcher;
import org.xbib.net.path.structure.PathSegment;

public class PathResolver<T>
implements org.xbib.net.path.PathResolver<T> {
    private static final Logger logger = Logger.getLogger(PathResolver.class.getName());
    private final Builder<T> builder;
    private final Map<PathSegment, PathResolver<T>> children;

    private PathResolver(Builder<T> builder) {
        this.builder = builder;
        this.children = new LinkedHashMap<PathSegment, PathResolver<T>>();
        for (Map.Entry entry : builder.children.entrySet()) {
            this.children.put(entry.getKey(), new PathResolver(entry.getValue()));
        }
    }

    @Override
    public void resolve(String method, String path, PathResolver.ResultListener<T> listener) throws ParameterException {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        List<PathSegment> pathSegments = PathMatcher.tokenize(PathNormalizer.normalize((String)path), this.builder.pathSeparator, this.builder.trimTokens, this.builder.caseSensitive);
        ParameterBuilder parameterBuilder = Parameter.builder().domain(Parameter.Domain.PATH).enableSort();
        this.resolve(pathSegments, 0, parameterBuilder, listener);
    }

    public String toString() {
        return "PathResolver[builder = " + String.valueOf(this.builder) + ", path resolver map = " + String.valueOf(this.children) + "]";
    }

    private ParameterBuilder resolve(List<PathSegment> pathSegments, int index, ParameterBuilder parameterBuilder, PathResolver.ResultListener<T> listener) throws ParameterException {
        ParameterBuilder pb = parameterBuilder;
        if (index < pathSegments.size()) {
            PathSegment segment = pathSegments.get(index);
            ArrayList<PathResolver<T>> list = new ArrayList<PathResolver<T>>();
            boolean shortCircuit = this.match(segment, list, pb);
            if (list.isEmpty()) {
                pb = Parameter.builder().domain(Parameter.Domain.PATH).enableSort();
            }
            if (shortCircuit) {
                PathResolver pathResolver = (PathResolver)list.get(list.size() - 1);
                if (pathResolver.builder.value != null) {
                    Object t = pathResolver.builder.value;
                    if (listener != null) {
                        listener.onResult(new Result(t, pb.build(), pathResolver.builder.method));
                        pb = Parameter.builder().domain(Parameter.Domain.PATH).enableSort();
                    }
                }
            } else {
                for (PathResolver pathResolver : list) {
                    pb = pathResolver.resolve(pathSegments, index + 1, pb, listener);
                }
            }
        } else if (this.builder.value != null) {
            Object value = this.builder.value;
            if (listener != null) {
                listener.onResult(new Result(value, pb.build(), this.builder.method));
                pb = Parameter.builder().domain(Parameter.Domain.PATH).enableSort();
            }
        }
        return pb;
    }

    private boolean match(PathSegment segment, List<PathResolver<T>> list, ParameterBuilder parameterBuilder) {
        boolean lastSegment = false;
        int i = 0;
        int size = this.children.size();
        for (PathSegment pathSegment : this.children.keySet()) {
            if (pathSegment.getParameterNames() != null) {
                this.matchAndExtractVariables(parameterBuilder, pathSegment, segment);
                PathResolver<T> pathResolver = this.children.get(pathSegment);
                list.add(pathResolver);
            } else if (pathSegment.getPattern() != null) {
                if (pathSegment.getPattern().matcher(segment.getString()).matches()) {
                    list.add(this.children.get(pathSegment));
                }
            } else if (pathSegment.getString().equals(segment.getString())) {
                list.add(this.children.get(pathSegment));
            } else if (pathSegment.isCatchAll()) {
                list.add(this.children.get(pathSegment));
                lastSegment = i == size - 1;
            }
            ++i;
        }
        logger.log(Level.INFO, "size = " + size + " lastSegment = " + lastSegment + " list.size() = " + list.size());
        return lastSegment;
    }

    private void matchAndExtractVariables(ParameterBuilder parameterBuilder, PathSegment patternSegment, PathSegment pathSegment) {
        if (patternSegment.getPattern() == null) {
            return;
        }
        Matcher matcher = patternSegment.getPattern().matcher(pathSegment.getString());
        if (matcher.matches()) {
            if (patternSegment.getParameterNames() == null) {
                return;
            }
            if (patternSegment.getParameterNames().size() != matcher.groupCount()) {
                throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + patternSegment.getString() + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
            }
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name = patternSegment.getParameterNames().get(i - 1);
                String value = matcher.group(i);
                parameterBuilder.add(name, (Object)value);
            }
        }
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private final Map<PathSegment, Builder<T>> children = new LinkedHashMap<PathSegment, Builder<T>>();
        private String pathSeparator = "/";
        private boolean trimTokens = true;
        private boolean caseSensitive = true;
        private T value;
        private String method;

        Builder() {
        }

        public Builder<T> pathSeparator(String pathSeparator) {
            this.pathSeparator = pathSeparator;
            return this;
        }

        public Builder<T> trimTokens(boolean trimTokens) {
            this.trimTokens = trimTokens;
            return this;
        }

        public Builder<T> caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder<T> add(String method, String pathSpec, T value) {
            Objects.requireNonNull(method, "method");
            Objects.requireNonNull(pathSpec, "pathSpec");
            Objects.requireNonNull(value, "value");
            PathMatcher pathMatcher = new PathMatcher(pathSpec, this.pathSeparator, this.trimTokens, this.caseSensitive, true, Parameter.builder().domain(Parameter.Domain.PATH).enableSort());
            this.add(pathMatcher.getAnalyzedSegments(), value, method, 0);
            return this;
        }

        public PathResolver<T> build() {
            return new PathResolver(this);
        }

        private void add(List<PathSegment> pathSegments, T value, String method, int index) {
            if (index < pathSegments.size()) {
                this.children.computeIfAbsent(pathSegments.get(index), k -> new Builder<T>().pathSeparator(this.pathSeparator).trimTokens(this.trimTokens).caseSensitive(this.caseSensitive)).add(pathSegments, value, method, index + 1);
            } else {
                this.value = value;
                this.method = method;
            }
        }
    }

    public static class Result<T>
    implements PathResolver.Result<T> {
        private final T value;
        private final Parameter parameter;
        private final String method;

        Result(T value, Parameter parameter, String method) {
            this.value = value;
            this.parameter = parameter;
            this.method = method;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : null;
        }
    }
}

