/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.oai.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xbib.oai.util.URIFormatter;

public class URIBuilder {
    private URI uri;
    private String scheme;
    private String authority;
    private String path;
    private String fragment;
    private Map<String, String> params;

    public URIBuilder() {
        this.params = new LinkedHashMap<String, String>();
    }

    public URIBuilder(String base) {
        this(URI.create(base));
    }

    public URIBuilder(URI base) {
        this.uri = base;
        this.scheme = this.uri.getScheme();
        this.authority = this.uri.getAuthority();
        this.path = this.uri.getPath();
        this.fragment = this.uri.getFragment();
        this.params = URIBuilder.parseQueryString(this.uri);
    }

    public URIBuilder(URI base, Charset encoding) {
        this.uri = base;
        this.params = URIBuilder.parseQueryString(this.uri, encoding);
    }

    public URIBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public URIBuilder authority(String authority) {
        this.authority = authority;
        return this;
    }

    public URIBuilder path(String path) {
        this.path = path;
        return this;
    }

    public URIBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public URIBuilder addParameter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public String buildGetPath() {
        return this.path + (this.params.isEmpty() ? "" : "?" + URIFormatter.renderQueryString(this.params));
    }

    public URIBuilder addParameter(String key, String value, Charset encoding) {
        this.params.put(key, URIFormatter.encode(value, encoding));
        return this;
    }

    public URI build() {
        try {
            return new URI(this.scheme, this.authority, this.path, URIFormatter.renderQueryString(this.params), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI build(Charset encoding) {
        try {
            return new URI(this.scheme, this.authority, this.path, URIFormatter.renderQueryString(this.params, encoding), this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, String> parseQueryString(URI uri) {
        return URIBuilder.parseQueryString(uri, StandardCharsets.UTF_8);
    }

    public static Map<String, String> parseQueryString(URI uri, Charset encoding) {
        return URIBuilder.parseQueryString(uri, encoding, null);
    }

    public static Map<String, String> parseQueryString(URI uri, Charset encoding, ParameterListener listener) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        return URIBuilder.parseQueryString(uri.getRawQuery(), encoding, listener);
    }

    public static Map<String, String> parseQueryString(String rawQuery, Charset encoding, ParameterListener listener) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (rawQuery == null) {
            return m;
        }
        StringTokenizer st = new StringTokenizer(rawQuery, "&");
        while (st.hasMoreTokens()) {
            String v;
            String k;
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos < 0) {
                k = pair;
                v = null;
            } else {
                k = pair.substring(0, pos);
                v = URIBuilder.decode(pair.substring(pos + 1, pair.length()), encoding);
            }
            m.put(k, v);
            if (listener == null) continue;
            listener.received(k, v);
        }
        return m;
    }

    public static String decode(String octet, Charset encoding) {
        StringBuilder sb = new StringBuilder();
        boolean fragment = false;
        block5: for (int i = 0; i < octet.length(); ++i) {
            char ch = octet.charAt(i);
            switch (ch) {
                case '+': {
                    sb.append(' ');
                    continue block5;
                }
                case '#': {
                    sb.append(ch);
                    fragment = true;
                    continue block5;
                }
                case '%': {
                    if (!fragment) {
                        sb.append((char)(Character.digit(octet.charAt(++i), 16) << 4 | Character.digit(octet.charAt(++i), 16)));
                        continue block5;
                    }
                    sb.append(ch);
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new String(sb.toString().getBytes(StandardCharsets.ISO_8859_1), encoding);
    }

    @FunctionalInterface
    public static interface ParameterListener {
        public void received(String var1, String var2);
    }
}

