/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.oai.util;

import java.nio.charset.Charset;
import java.util.Map;

public class URIFormatter {
    private static final String hex = "0123456789ABCDEF";

    public static String renderQueryString(Map<String, String> m) {
        return URIFormatter.renderQueryString(m, null, false);
    }

    public static String renderQueryString(Map<String, String> m, Charset encoding) {
        return URIFormatter.renderQueryString(m, encoding, true);
    }

    public static String renderQueryString(Map<String, String> m, Charset encoding, boolean encode) {
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, String> me : m.entrySet()) {
            String value;
            String key = me.getKey();
            String string = value = encode ? URIFormatter.encode(me.getValue(), encoding) : me.getValue();
            if (key == null) continue;
            if (out.length() > 0) {
                out.append("&");
            }
            out.append(key);
            if (value == null || value.length() <= 0) continue;
            out.append("=").append(value);
        }
        return out.toString();
    }

    public static String encode(String s, Charset encoding) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        int start = 0;
        int i = 0;
        StringBuilder result = new StringBuilder(length);
        while (true) {
            if (i < length && URIFormatter.isSafe(s.charAt(i))) {
                ++i;
                continue;
            }
            result.append(s.substring(start, i));
            if (i >= length) {
                return result.toString();
            }
            if (s.charAt(i) == ' ') {
                result.append('+');
            } else {
                byte[] bytes;
                char c;
                start = i;
                while (i < length && (c = s.charAt(i)) != ' ' && !URIFormatter.isSafe(c)) {
                    ++i;
                }
                String unsafe = s.substring(start, i);
                for (byte aByte : bytes = unsafe.getBytes(encoding)) {
                    result.append('%');
                    result.append(hex.charAt((aByte & 0xF0) >> 4));
                    result.append(hex.charAt(aByte & 0xF));
                }
            }
            start = ++i;
        }
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*';
    }
}

