/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.oai.util;

import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ResumptionToken<T> {
    private static final int DEFAULT_INTERVAL_SIZE = 1000;
    private static final ConcurrentHashMap<UUID, ResumptionToken<?>> cache = new ConcurrentHashMap();
    private final UUID uuid = UUID.randomUUID();
    private final int interval;
    private int position = 0;
    private T value;
    private Date expirationDate;
    private int completeListSize;
    private int cursor;
    private String metadataPrefix;
    private String set;
    private Date from;
    private Date until;
    private boolean completed;

    private ResumptionToken() {
        this(1000);
        this.completed = false;
    }

    private ResumptionToken(int interval) {
        this.interval = interval;
        this.value = null;
        cache.put(this.uuid, this);
    }

    public static <T> ResumptionToken<T> newToken(T value) {
        return new ResumptionToken<T>().setValue(value);
    }

    public static ResumptionToken<?> get(UUID token) {
        return cache.get(token);
    }

    public UUID getKey() {
        return this.uuid;
    }

    public ResumptionToken<T> setPosition(int position) {
        this.position = position;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public int advancePosition() {
        this.setPosition(this.position + this.interval);
        return this.getPosition();
    }

    public int getInterval() {
        return this.interval;
    }

    public ResumptionToken<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public ResumptionToken<T> setExpirationDate(Date date) {
        this.expirationDate = date;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public ResumptionToken<T> setCompleteListSize(int size) {
        this.completeListSize = size;
        this.completed = size < this.interval;
        return this;
    }

    public int getCompleteListSize() {
        return this.completeListSize;
    }

    public ResumptionToken<T> setCursor(int cursor) {
        this.cursor = cursor;
        return this;
    }

    public int getCursor() {
        return this.cursor;
    }

    public ResumptionToken<T> setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
        return this;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public ResumptionToken<T> setSet(String set) {
        this.set = set;
        return this;
    }

    public String getSet() {
        return this.set;
    }

    public ResumptionToken<T> setFrom(Date from) {
        this.from = from;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public ResumptionToken<T> setUntil(Date until) {
        this.until = until;
        return this;
    }

    public Date getUntil() {
        return this.until;
    }

    public void update(int completeListSize, int pageSize, int currentPage) {
        this.completeListSize = completeListSize;
        this.cursor = pageSize * currentPage;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }
}

