/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.oai.rdf;

import java.io.IOException;
import org.xbib.content.rdf.RdfContentBuilder;
import org.xbib.content.rdf.RdfContentParams;
import org.xbib.content.rdf.Resource;
import org.xbib.content.rdf.internal.DefaultAnonymousResource;
import org.xbib.content.rdf.io.xml.XmlResourceHandler;
import org.xbib.content.resource.IRI;
import org.xbib.content.resource.IRINamespaceContext;
import org.xbib.oai.OAIConstants;
import org.xbib.oai.rdf.RdfResourceHandler;
import org.xbib.oai.xml.SimpleMetadataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RdfSimpleMetadataHandler
extends SimpleMetadataHandler
implements OAIConstants {
    private RdfResourceHandler handler;
    private Resource resource;
    private RdfContentBuilder<?> builder;
    private RdfContentParams params;

    public RdfSimpleMetadataHandler() {
        this(RdfSimpleMetadataHandler::getDefaultContext);
    }

    public RdfSimpleMetadataHandler(RdfContentParams params) {
        this.params = params;
        this.resource = new DefaultAnonymousResource();
        this.handler = new RdfResourceHandler(params);
        this.handler.setDefaultNamespace("oai", "http://www.openarchives.org/OAI/2.0/");
    }

    public static IRINamespaceContext getDefaultContext() {
        IRINamespaceContext context = IRINamespaceContext.newInstance();
        context.addNamespace("dc", "http://www.purl.org/dc/elements/1.1/");
        context.addNamespace("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        return context;
    }

    public IRINamespaceContext getContext() {
        return this.params.getNamespaceContext();
    }

    public Resource getResource() {
        return this.resource;
    }

    public RdfSimpleMetadataHandler setHandler(RdfResourceHandler handler) {
        handler.setDefaultNamespace("oai", "http://www.openarchives.org/OAI/2.0/");
        this.handler = handler;
        return this;
    }

    public XmlResourceHandler<RdfContentParams> getHandler() {
        return this.handler;
    }

    public RdfSimpleMetadataHandler setBuilder(RdfContentBuilder<?> builder) {
        this.builder = builder;
        return this;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.handler != null) {
            this.handler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        String id = this.getHeader().getIdentifier().trim();
        if (this.handler != null) {
            this.handler.identify(null, id, null);
            this.resource.setId(IRI.create((String)id));
            this.handler.endDocument();
            try {
                if (this.builder != null) {
                    this.builder.receive(this.resource);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (this.handler != null) {
            this.handler.startPrefixMapping(prefix, namespaceURI);
            if (prefix.isEmpty()) {
                this.handler.setDefaultNamespace("oai", namespaceURI);
            }
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.handler != null) {
            this.handler.endPrefixMapping(string);
        }
    }

    @Override
    public void startElement(String ns, String localname, String string2, Attributes atrbts) throws SAXException {
        if (this.handler != null) {
            this.handler.startElement(ns, localname, string2, atrbts);
        }
    }

    @Override
    public void endElement(String ns, String localname, String string2) throws SAXException {
        if (this.handler != null) {
            this.handler.endElement(ns, localname, string2);
        }
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        if (this.handler != null) {
            this.handler.characters(chars, i, i1);
        }
    }
}

