/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.oai.xml;

import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.xbib.oai.OAIConstants;
import org.xbib.oai.xml.SimpleMetadataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlSimpleMetadataHandler
extends SimpleMetadataHandler
implements OAIConstants {
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private List<String> namespaces = new ArrayList<String>();
    private final Deque<Collection<Namespace>> nsStack = new ArrayDeque<Collection<Namespace>>();
    private Locator locator;
    private XMLEventWriter eventWriter;
    private Writer writer;
    private String id;
    private boolean needToCallStartDocument = false;

    public XmlSimpleMetadataHandler setWriter(Writer writer) throws XMLStreamException {
        this.writer = writer;
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        this.eventWriter = outputFactory.createXMLEventWriter(writer);
        return this;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public XmlSimpleMetadataHandler setEventWriter(XMLEventWriter eventWriter) {
        this.eventWriter = eventWriter;
        return this;
    }

    public XMLEventWriter getEventWriter() {
        return this.eventWriter;
    }

    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Location getCurrentLocation() {
        if (this.locator != null) {
            return new SAXLocation(this.locator);
        }
        return null;
    }

    @Override
    public void startDocument() {
        if (this.eventWriter == null) {
            return;
        }
        this.namespaces.clear();
        this.nsStack.clear();
        eventFactory.setLocation(this.getCurrentLocation());
        this.needToCallStartDocument = true;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.eventWriter == null) {
            return;
        }
        this.id = this.getHeader().getIdentifier().trim();
        try {
            eventFactory.setLocation(this.getCurrentLocation());
            this.eventWriter.add(eventFactory.createEndDocument());
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
        this.namespaces.clear();
        this.nsStack.clear();
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) {
        if (this.eventWriter == null) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        if (prefix == null) {
            this.namespaces.add("");
            this.namespaces.add(namespaceURI);
            return;
        }
        if ("xml".equals(prefix)) {
            return;
        }
        this.namespaces.add(prefix);
        this.namespaces.add(namespaceURI);
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
        if (this.eventWriter == null) {
            return;
        }
        if (this.needToCallStartDocument) {
            try {
                this.eventWriter.add(eventFactory.createStartDocument());
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
            this.needToCallStartDocument = false;
        }
        ArrayList<Attribute> attr = new ArrayList<Attribute>();
        ArrayList<Namespace> ns = new ArrayList<Namespace>();
        this.createStartEvents(attributes, attr, ns);
        this.nsStack.add(ns);
        try {
            String[] q = new String[]{null, null};
            this.parseQName(qname, q);
            eventFactory.setLocation(this.getCurrentLocation());
            this.eventWriter.add(eventFactory.createStartElement(q[0], uri, q[1], attr.iterator(), ns.iterator()));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (this.eventWriter == null) {
            return;
        }
        String[] q = new String[]{null, null};
        this.parseQName(qname, q);
        Iterator<Namespace> nsIter = this.nsStack.getLast().iterator();
        try {
            eventFactory.setLocation(this.getCurrentLocation());
            this.eventWriter.add(eventFactory.createEndElement(q[0], uri, q[1], nsIter));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        if (this.eventWriter == null) {
            return;
        }
        try {
            eventFactory.setLocation(this.getCurrentLocation());
            this.eventWriter.add(eventFactory.createCharacters(new String(chars, i, i1)));
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private void createStartEvents(Attributes attributes, Collection<Attribute> attrList, Collection<Namespace> nsList) {
        int i;
        HashMap<String, Namespace> nsMap = null;
        ArrayList<Attribute> attrs = null;
        if (this.namespaces != null) {
            int nDecls = this.namespaces.size();
            for (i = 0; i < nDecls; ++i) {
                String prefix = this.namespaces.get(i);
                String uri = this.namespaces.get(i++);
                Namespace ns = this.createNamespace(prefix, uri);
                if (nsMap == null) {
                    nsMap = new HashMap<String, Namespace>();
                }
                nsMap.put(prefix, ns);
            }
        }
        String[] qname = new String[]{null, null};
        int s = attributes.getLength();
        for (i = 0; i < s; ++i) {
            this.parseQName(attributes.getQName(i), qname);
            String attrPrefix = qname[0];
            String attrLocal = qname[1];
            String attrQName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            String attrURI = attributes.getURI(i);
            if ("xmlns".equals(attrQName) || "xmlns".equals(attrPrefix)) {
                if (attrValue.isEmpty() || nsMap == null || nsMap.containsKey(attrPrefix)) continue;
                Namespace ns = this.createNamespace(attrPrefix, attrValue);
                nsMap = new HashMap();
                nsMap.put(attrPrefix, ns);
                continue;
            }
            Attribute attribute = attrPrefix.length() > 0 && !attrValue.isEmpty() ? eventFactory.createAttribute(attrPrefix, attrURI, attrLocal, attrValue) : eventFactory.createAttribute(attrLocal, attrValue);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
            }
            attrs.add(attribute);
        }
        if (nsMap != null) {
            nsList.addAll(nsMap.values());
        }
        if (attrs != null) {
            attrList.addAll(attrs);
        }
    }

    private void parseQName(String qName, String[] results) {
        String local;
        String prefix;
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            prefix = qName.substring(0, idx);
            local = qName.substring(idx + 1);
        } else {
            prefix = "";
            local = qName;
        }
        results[0] = prefix;
        results[1] = local;
    }

    private Namespace createNamespace(String prefix, String uri) {
        if (prefix == null || prefix.length() == 0) {
            return eventFactory.createNamespace(uri);
        }
        return eventFactory.createNamespace(prefix, uri);
    }

    private static final class SAXLocation
    implements Location {
        private final int lineNumber;
        private final int columnNumber;
        private final String publicId;
        private final String systemId;

        private SAXLocation(Locator locator) {
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }
    }
}

