/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.rpm.ant;

import java.util.EnumSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.TarFileSet;
import org.xbib.rpm.payload.Directive;

public class RpmFileSet
extends TarFileSet {
    private EnumSet<Directive> directives = EnumSet.of(Directive.NONE);

    public RpmFileSet() {
    }

    protected RpmFileSet(FileSet fileset) {
        super(fileset);
    }

    protected RpmFileSet(RpmFileSet fileset) {
        super((TarFileSet)fileset);
        this.directives = fileset.getDirectives();
    }

    public EnumSet<Directive> getDirectives() {
        return this.directives;
    }

    public void setGhost(boolean ghost) {
        this.checkRpmFileSetAttributesAllowed();
        if (ghost) {
            this.directives.add(Directive.GHOST);
        } else {
            this.directives.remove(Directive.GHOST);
        }
    }

    public void setConfig(boolean config) {
        this.checkRpmFileSetAttributesAllowed();
        if (config) {
            this.directives.add(Directive.CONFIG);
        } else {
            this.directives.remove(Directive.CONFIG);
        }
    }

    public void setNoReplace(boolean noReplace) {
        this.checkRpmFileSetAttributesAllowed();
        if (noReplace) {
            this.directives.add(Directive.NOREPLACE);
        } else {
            this.directives.remove(Directive.NOREPLACE);
        }
    }

    public void setDoc(boolean doc) {
        this.checkRpmFileSetAttributesAllowed();
        if (doc) {
            this.directives.add(Directive.DOC);
        } else {
            this.directives.remove(Directive.DOC);
        }
    }

    public Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        return super.clone();
    }

    private void checkRpmFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof RpmFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

