/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.rpm.ant;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.xbib.rpm.RpmBuilder;
import org.xbib.rpm.ant.BuiltIn;
import org.xbib.rpm.ant.Conflicts;
import org.xbib.rpm.ant.Depends;
import org.xbib.rpm.ant.Obsoletes;
import org.xbib.rpm.ant.Provides;
import org.xbib.rpm.ant.RpmFileSet;
import org.xbib.rpm.exception.RpmException;
import org.xbib.rpm.header.EntryType;
import org.xbib.rpm.header.HeaderTag;
import org.xbib.rpm.lead.Architecture;
import org.xbib.rpm.lead.Os;
import org.xbib.rpm.lead.PackageType;
import org.xbib.rpm.payload.CpioHeader;
import org.xbib.rpm.payload.Directive;
import org.xbib.rpm.payload.EmptyDir;
import org.xbib.rpm.payload.Ghost;
import org.xbib.rpm.payload.Link;
import org.xbib.rpm.trigger.TriggerIn;
import org.xbib.rpm.trigger.TriggerPostUn;
import org.xbib.rpm.trigger.TriggerPreIn;
import org.xbib.rpm.trigger.TriggerUn;

public class RpmTask
extends Task {
    private String name;
    private String epoch = "0";
    private String version;
    private String group;
    private String release = "1";
    private String host;
    private String summary = "";
    private String description = "";
    private String license = "";
    private String packager = System.getProperty("user.name", "");
    private String distribution = "";
    private String vendor = "";
    private String url = "";
    private String sourcePackage = null;
    private String provides;
    private String prefixes;
    private PackageType type = PackageType.BINARY;
    private Architecture architecture = Architecture.NOARCH;
    private Os os = Os.LINUX;
    private Path destination;
    private List<ArchiveFileSet> filesets = new ArrayList<ArchiveFileSet>();
    private List<EmptyDir> emptyDirs = new ArrayList<EmptyDir>();
    private List<Ghost> ghosts = new ArrayList<Ghost>();
    private List<Link> links = new ArrayList<Link>();
    List<Depends> depends = new ArrayList<Depends>();
    private List<Provides> moreProvides = new ArrayList<Provides>();
    private List<Conflicts> conflicts = new ArrayList<Conflicts>();
    private List<Obsoletes> obsoletes = new ArrayList<Obsoletes>();
    private List<TriggerPreIn> triggersPreIn = new ArrayList<TriggerPreIn>();
    private List<TriggerIn> triggersIn = new ArrayList<TriggerIn>();
    private List<TriggerUn> triggersUn = new ArrayList<TriggerUn>();
    private List<TriggerPostUn> triggersPostUn = new ArrayList<TriggerPostUn>();
    private List<BuiltIn> builtIns = new ArrayList<BuiltIn>();
    private Path preTransScript;
    private Path preInstallScript;
    private Path postInstallScript;
    private Path preUninstallScript;
    private Path postUninstallScript;
    private Path postTransScript;
    private InputStream privateKeyRing;
    private Long privateKeyId;
    private String privateKeyPassphrase;
    private Path changeLog;

    public RpmTask() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.host = "";
        }
    }

    public void execute() {
        Integer numEpoch;
        if (this.name == null) {
            throw new BuildException("attribute 'name' is required");
        }
        if (this.version == null) {
            throw new BuildException("attribute 'version' is required");
        }
        if (this.group == null) {
            throw new BuildException("attribute 'group' is required");
        }
        try {
            numEpoch = Integer.parseInt(this.epoch);
        }
        catch (Exception e) {
            throw new BuildException("epoch must be integer: " + this.epoch);
        }
        RpmBuilder rpmBuilder = new RpmBuilder();
        rpmBuilder.setPackage((CharSequence)this.name, (CharSequence)this.version, (CharSequence)this.release, numEpoch);
        rpmBuilder.setType(this.type);
        rpmBuilder.setPlatform(this.architecture, this.os);
        rpmBuilder.setGroup((CharSequence)this.group);
        rpmBuilder.setBuildHost((CharSequence)this.host);
        rpmBuilder.setSummary((CharSequence)this.summary);
        rpmBuilder.setDescription((CharSequence)this.description);
        rpmBuilder.setLicense((CharSequence)this.license);
        rpmBuilder.setPackager((CharSequence)this.packager);
        rpmBuilder.setDistribution((CharSequence)this.distribution);
        rpmBuilder.setVendor((CharSequence)this.vendor);
        rpmBuilder.setUrl((CharSequence)this.url);
        if (this.provides != null) {
            rpmBuilder.setProvides((CharSequence)this.provides);
        }
        rpmBuilder.setPrefixes(this.prefixes == null ? null : this.prefixes.split(","));
        rpmBuilder.setPrivateKeyRing(this.privateKeyRing);
        rpmBuilder.setPrivateKeyId(this.privateKeyId);
        rpmBuilder.setPrivateKeyPassphrase(this.privateKeyPassphrase);
        if (this.sourcePackage != null) {
            rpmBuilder.addHeaderEntry((EntryType)HeaderTag.SOURCERPM, this.sourcePackage);
        }
        for (BuiltIn builtIn : this.builtIns) {
            String text = builtIn.getText();
            if (text == null || text.trim().equals("")) continue;
            rpmBuilder.addBuiltinDirectory(builtIn.getText());
        }
        try {
            if (this.preTransScript != null) {
                rpmBuilder.setPreTrans(this.preTransScript);
            }
            if (this.preInstallScript != null) {
                rpmBuilder.setPreInstall(this.preInstallScript);
            }
            if (this.postInstallScript != null) {
                rpmBuilder.setPostInstall(this.postInstallScript);
            }
            if (this.preUninstallScript != null) {
                rpmBuilder.setPreUninstall(this.preUninstallScript);
            }
            if (this.postUninstallScript != null) {
                rpmBuilder.setPostUninstall(this.postUninstallScript);
            }
            if (this.postTransScript != null) {
                rpmBuilder.setPostTrans(this.postTransScript);
            }
            if (this.changeLog != null) {
                rpmBuilder.addChangelog(this.changeLog);
            }
            for (EmptyDir emptyDir : this.emptyDirs) {
                rpmBuilder.addDirectory(emptyDir.getPath(), emptyDir.getDirmode(), EnumSet.of(Directive.NONE), emptyDir.getUsername(), emptyDir.getGroup(), true);
            }
            for (ArchiveFileSet fileset : this.filesets) {
                Path archive = fileset.getSrc(this.getProject()) != null ? fileset.getSrc(this.getProject()).toPath() : null;
                String prefix = CpioHeader.normalizePath((String)fileset.getPrefix(this.getProject()));
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                DirectoryScanner directoryScanner = fileset.getDirectoryScanner(this.getProject());
                Integer filemode = fileset.getFileMode(this.getProject()) & 0xFFF;
                Integer dirmode = fileset.getDirMode(this.getProject()) & 0xFFF;
                String username = null;
                String group = null;
                EnumSet<Directive> directive = null;
                if (fileset instanceof TarFileSet) {
                    TarFileSet tarFileSet = (TarFileSet)fileset;
                    username = tarFileSet.getUserName();
                    group = tarFileSet.getGroup();
                    if (fileset instanceof RpmFileSet) {
                        RpmFileSet rpmFileSet = (RpmFileSet)fileset;
                        directive = rpmFileSet.getDirectives();
                    }
                }
                for (String entry : directoryScanner.getIncludedDirectories()) {
                    String dir = CpioHeader.normalizePath((String)(prefix + entry));
                    if ("".equals(entry)) continue;
                    rpmBuilder.addDirectory(dir, dirmode.intValue(), directive, username, group, true);
                }
                for (String entry : directoryScanner.getIncludedFiles()) {
                    if (archive != null) {
                        URL url = new URL("jar:" + archive.toUri().toURL() + "!/" + entry);
                        rpmBuilder.addURL(prefix + entry, url, filemode.intValue(), dirmode.intValue(), directive, username, group);
                        continue;
                    }
                    Path path = directoryScanner.getBasedir().toPath().resolve(entry);
                    rpmBuilder.addFile(prefix + entry, path, filemode.intValue(), dirmode.intValue(), directive, username, group);
                }
            }
            for (Ghost ghost : this.ghosts) {
                rpmBuilder.addFile(ghost.getPath(), null, ghost.getFilemode(), ghost.getDirmode(), ghost.getDirectives(), ghost.getUsername(), ghost.getGroup());
            }
            for (Link link : this.links) {
                rpmBuilder.addLink(link.getPath(), link.getTarget(), link.getPermissions());
            }
            for (Depends dependency : this.depends) {
                rpmBuilder.addDependency(dependency.getName(), dependency.getComparison(), dependency.getVersion());
            }
            for (Provides provision : this.moreProvides) {
                rpmBuilder.addProvides(provision.getName(), provision.getVersion());
            }
            for (Conflicts conflict : this.conflicts) {
                rpmBuilder.addConflicts(conflict.getName(), conflict.getComparison(), conflict.getVersion());
            }
            for (Obsoletes obsoletion : this.obsoletes) {
                rpmBuilder.addObsoletes(obsoletion.getName(), obsoletion.getComparison(), obsoletion.getVersion());
            }
            for (TriggerPreIn triggerPreIn : this.triggersPreIn) {
                rpmBuilder.addTrigger(triggerPreIn.getScript(), "", triggerPreIn.getDepends(), triggerPreIn.getFlag());
            }
            for (TriggerIn triggerIn : this.triggersIn) {
                rpmBuilder.addTrigger(triggerIn.getScript(), "", triggerIn.getDepends(), triggerIn.getFlag());
            }
            for (TriggerUn triggerUn : this.triggersUn) {
                rpmBuilder.addTrigger(triggerUn.getScript(), "", triggerUn.getDepends(), triggerUn.getFlag());
            }
            for (TriggerPostUn triggerPostUn : this.triggersPostUn) {
                rpmBuilder.addTrigger(triggerPostUn.getScript(), "", triggerPostUn.getDepends(), triggerPostUn.getFlag());
            }
            rpmBuilder.build(this.destination);
        }
        catch (IOException | RpmException e) {
            throw new BuildException("error while building package", e);
        }
    }

    public void restrict(String name) {
        this.depends.removeIf(dependency -> dependency.getName().equals(name));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEpoch(String epoch) {
        this.epoch = epoch;
    }

    public void setType(String type) {
        this.type = PackageType.valueOf((String)type);
    }

    public void setArchitecture(String architecture) {
        this.architecture = Architecture.valueOf((String)architecture);
    }

    public void setOs(String os) {
        this.os = Os.valueOf((String)os);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setPackager(String packager) {
        this.packager = packager;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProvides(String provides) {
        this.provides = provides;
    }

    public void setPrefixes(String prefixes) {
        this.prefixes = prefixes;
    }

    public void setDestination(Path destination) {
        this.destination = destination;
    }

    public void addZipfileset(ZipFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addTarfileset(TarFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addRpmfileset(RpmFileSet fileset) {
        this.filesets.add((ArchiveFileSet)fileset);
    }

    public void addGhost(Ghost ghost) {
        this.ghosts.add(ghost);
    }

    public void addEmptyDir(EmptyDir emptyDir) {
        this.emptyDirs.add(emptyDir);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addDepends(Depends dependency) {
        this.depends.add(dependency);
    }

    public void addProvides(Provides provision) {
        this.moreProvides.add(provision);
    }

    public void addConflicts(Conflicts conflict) {
        this.conflicts.add(conflict);
    }

    public void addObsoletes(Obsoletes obsoletion) {
        this.obsoletes.add(obsoletion);
    }

    public void addTriggerPreIn(TriggerPreIn triggerPreIn) {
        this.triggersPreIn.add(triggerPreIn);
    }

    public void addTriggerIn(TriggerIn triggerIn) {
        this.triggersIn.add(triggerIn);
    }

    public void addTriggerUn(TriggerUn triggerUn) {
        this.triggersUn.add(triggerUn);
    }

    public void addTriggerPostUn(TriggerPostUn triggerPostUn) {
        this.triggersPostUn.add(triggerPostUn);
    }

    public void setPreTransScript(Path preTransScript) {
        this.preTransScript = preTransScript;
    }

    public void setPreInstallScript(Path preInstallScript) {
        this.preInstallScript = preInstallScript;
    }

    public void setPostInstallScript(Path postInstallScript) {
        this.postInstallScript = postInstallScript;
    }

    public void setPreUninstallScript(Path preUninstallScript) {
        this.preUninstallScript = preUninstallScript;
    }

    public void setPostUninstallScript(Path postUninstallScript) {
        this.postUninstallScript = postUninstallScript;
    }

    public void setPostTransScript(Path postTransScript) {
        this.postTransScript = postTransScript;
    }

    public void setSourcePackage(String sourcePackage) {
        this.sourcePackage = sourcePackage;
    }

    public void setPrivateKeyRing(Path privateKeyRing) throws IOException {
        this.privateKeyRing = Files.newInputStream(privateKeyRing, new OpenOption[0]);
    }

    public void setPrivateKeyRing(InputStream privateKeyRing) {
        this.privateKeyRing = privateKeyRing;
    }

    public void setPrivateKeyId(Long privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = Long.decode("0x" + privateKeyId);
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void addBuiltin(BuiltIn builtIn) {
        this.builtIns.add(builtIn);
    }

    public void setChangeLog(Path changeLog) {
        this.changeLog = changeLog;
    }
}

