/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.sshd.eddsa;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public class EdDSASecurityProvider
extends Provider {
    public static final String PROVIDER_NAME = "EdDSA";
    private static final long serialVersionUID = 1210027906682292307L;

    public EdDSASecurityProvider() {
        super(PROVIDER_NAME, 0.1, "xbib EdDSA security provider wrapper");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                EdDSASecurityProvider.this.setup();
                return null;
            }
        });
    }

    protected void setup() {
        this.put("KeyFactory.EdDSA", "org.xbib.io.sshd.eddsa.KeyFactory");
        this.put("KeyPairGenerator.EdDSA", "org.xbib.io.sshd.eddsa.KeyPairGenerator");
        this.put("Signature.NONEwithEdDSA", "org.xbib.io.sshd.eddsa.EdDSAEngine");
        this.put("Alg.Alias.KeyFactory.1.3.101.112", PROVIDER_NAME);
        this.put("Alg.Alias.KeyFactory.OID.1.3.101.112", PROVIDER_NAME);
        this.put("Alg.Alias.KeyPairGenerator.1.3.101.112", PROVIDER_NAME);
        this.put("Alg.Alias.KeyPairGenerator.OID.1.3.101.112", PROVIDER_NAME);
        this.put("Alg.Alias.Signature.1.3.101.112", "NONEwithEdDSA");
        this.put("Alg.Alias.Signature.OID.1.3.101.112", "NONEwithEdDSA");
    }
}

