/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.sshd.eddsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import org.xbib.io.sshd.eddsa.EdDSAPrivateKey;
import org.xbib.io.sshd.eddsa.EdDSAPublicKey;
import org.xbib.io.sshd.eddsa.spec.EdDSAGenParameterSpec;
import org.xbib.io.sshd.eddsa.spec.EdDSANamedCurveSpec;
import org.xbib.io.sshd.eddsa.spec.EdDSANamedCurveTable;
import org.xbib.io.sshd.eddsa.spec.EdDSAParameterSpec;
import org.xbib.io.sshd.eddsa.spec.EdDSAPrivateKeySpec;
import org.xbib.io.sshd.eddsa.spec.EdDSAPublicKeySpec;

public final class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int DEFAULT_KEYSIZE = 256;
    private static final Hashtable<Integer, AlgorithmParameterSpec> edParameters = new Hashtable();
    private EdDSAParameterSpec edParams;
    private SecureRandom random;
    private boolean initialized;

    @Override
    public void initialize(int keysize, SecureRandom random) {
        AlgorithmParameterSpec edParams = edParameters.get(keysize);
        if (edParams == null) {
            throw new InvalidParameterException("unknown key type.");
        }
        try {
            this.initialize(edParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException("key type not configurable.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof EdDSAParameterSpec) {
            this.edParams = (EdDSAParameterSpec)params;
        } else if (params instanceof EdDSAGenParameterSpec) {
            this.edParams = this.createNamedCurveSpec(((EdDSAGenParameterSpec)params).getName());
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a EdDSAParameterSpec");
        }
        this.random = random;
        this.initialized = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initialize(256, new SecureRandom());
        }
        byte[] seed = new byte[this.edParams.getCurve().getField().getb() / 8];
        this.random.nextBytes(seed);
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(seed, this.edParams);
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(privKey.getA(), this.edParams);
        return new KeyPair(new EdDSAPublicKey(pubKey), new EdDSAPrivateKey(privKey));
    }

    protected EdDSANamedCurveSpec createNamedCurveSpec(String curveName) throws InvalidAlgorithmParameterException {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName(curveName);
        if (spec == null) {
            throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
        }
        return spec;
    }

    static {
        edParameters.put(256, new EdDSAGenParameterSpec("Ed25519"));
    }
}

