/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.sshd.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.util.Objects;
import org.xbib.io.sshd.client.subsystem.sftp.SftpClient;
import org.xbib.io.sshd.common.subsystem.sftp.SftpException;
import org.xbib.io.sshd.common.util.logging.AbstractLoggingBean;
import org.xbib.io.sshd.fs.SftpFileSystem;
import org.xbib.io.sshd.fs.SftpFileSystemProvider;
import org.xbib.io.sshd.fs.SftpPath;

public abstract class AbstractSftpFileAttributeView
extends AbstractLoggingBean
implements FileAttributeView {
    protected final SftpFileSystemProvider provider;
    protected final Path path;
    protected final LinkOption[] options;

    protected AbstractSftpFileAttributeView(SftpFileSystemProvider provider, Path path, LinkOption ... options) {
        this.provider = Objects.requireNonNull(provider, "No file system provider instance");
        this.path = Objects.requireNonNull(path, "No path");
        this.options = options;
    }

    @Override
    public String name() {
        return "view";
    }

    public final SftpFileSystemProvider provider() {
        return this.provider;
    }

    public final Path getPath() {
        return this.path;
    }

    protected SftpClient.Attributes readRemoteAttributes() throws IOException {
        return this.provider.readRemoteAttributes(this.provider.toSftpPath(this.path), this.options);
    }

    protected void writeRemoteAttributes(SftpClient.Attributes attrs) throws IOException {
        SftpPath p = this.provider.toSftpPath(this.path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        try (SftpClient client = fs.getClient();){
            try {
                client.setStat(p.toString(), attrs);
            }
            catch (SftpException e) {
                if (e.getStatus() == 2) {
                    throw new NoSuchFileException(p.toString());
                }
                throw e;
            }
        }
    }
}

