/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1BitString;
import org.xbib.asn1.ASN1Decoder;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectDescriptor;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1External
extends ASN1Any {
    public static final int EXTERNAL_TAG = 8;
    private ASN1ObjectIdentifier sDirectReference;
    private ASN1Integer sIndirectReference;
    private ASN1ObjectDescriptor sDataValueDescriptor;
    private ASN1Any cSingleASN1Type;
    private ASN1OctetString cOctetAligned;
    private ASN1BitString cArbitrary;

    public ASN1External() {
    }

    public ASN1External(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1Exception {
        if (checkTag && (berEncoding.getTag() != 8 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.getTag() + " expected " + 8 + "\n");
        }
        if (berEncoding instanceof BERPrimitive) {
            throw new ASN1EncodingException("incorrect form, primitive encoding");
        }
        BERConstructed ber = (BERConstructed)berEncoding;
        this.sDirectReference = null;
        this.sIndirectReference = null;
        this.sDataValueDescriptor = null;
        this.cSingleASN1Type = null;
        this.cOctetAligned = null;
        this.cArbitrary = null;
        int numParts = ber.numberComponents();
        if (numParts < 1) {
            throw new ASN1EncodingException("incomplete");
        }
        int part = 0;
        BEREncoding p = ber.elementAt(part);
        if (p.getTag() == 6 && p.getTagType() == 0) {
            this.sDirectReference = new ASN1ObjectIdentifier(p, true);
            if (numParts <= ++part) {
                throw new ASN1EncodingException("incomplete");
            }
            p = ber.elementAt(part);
        }
        if (p.getTag() == 2 && p.getTagType() == 0) {
            this.sIndirectReference = new ASN1Integer(p, true);
            if (numParts <= ++part) {
                throw new ASN1EncodingException("incomplete");
            }
            p = ber.elementAt(part);
        }
        if (p.getTag() == 7 && p.getTagType() == 0) {
            this.sDataValueDescriptor = new ASN1ObjectDescriptor(p, true);
            if (numParts <= ++part) {
                throw new ASN1EncodingException("incomplete");
            }
            p = ber.elementAt(part);
        }
        switch (p.getTag()) {
            case 0: {
                if (!(p instanceof BERConstructed)) {
                    throw new ASN1EncodingException("singleASN1type: bad form, primitive");
                }
                if (((BERConstructed)p).numberComponents() != 1) {
                    throw new ASN1EncodingException("singleASN1type: bad form, no explicit tag");
                }
                this.cSingleASN1Type = ASN1Decoder.toASN1(((BERConstructed)p).elementAt(0));
                break;
            }
            case 1: {
                if (p.getTagType() != 128) {
                    throw new ASN1EncodingException("encoding: bad tag type " + p);
                }
                this.cOctetAligned = new ASN1OctetString(p, false);
                break;
            }
            case 2: {
                if (p.getTagType() != 128) {
                    throw new ASN1EncodingException("encoding: bad tag type " + p);
                }
                this.cArbitrary = new ASN1BitString(p, false);
                break;
            }
            default: {
                throw new ASN1EncodingException("encoding: tag = " + p.getTag());
            }
        }
        if (part != numParts - 1) {
            throw new ASN1Exception("extra element(s)");
        }
    }

    public ASN1OctetString getcOctetAligned() {
        return this.cOctetAligned;
    }

    public ASN1Any getSingleASN1Type() {
        return this.cSingleASN1Type;
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 8);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numParts = 0;
        if (this.cSingleASN1Type != null) {
            ++numParts;
        }
        if (this.cOctetAligned != null) {
            ++numParts;
        }
        if (this.cArbitrary != null) {
            ++numParts;
        }
        if (numParts < 1) {
            throw new ASN1Exception("no encoding has been set");
        }
        if (1 < numParts) {
            throw new ASN1Exception("more than one encoding set");
        }
        if (this.sDirectReference != null) {
            ++numParts;
        }
        if (this.sIndirectReference != null) {
            ++numParts;
        }
        if (this.sDataValueDescriptor != null) {
            ++numParts;
        }
        BEREncoding[] parts = new BEREncoding[numParts];
        int part = 0;
        if (this.sDirectReference != null) {
            parts[part++] = this.sDirectReference.berEncode();
        }
        if (this.sIndirectReference != null) {
            parts[part++] = this.sIndirectReference.berEncode();
        }
        if (this.sDataValueDescriptor != null) {
            parts[part++] = this.sDataValueDescriptor.berEncode();
        }
        if (this.cSingleASN1Type != null) {
            BEREncoding[] contents = new BEREncoding[]{this.cSingleASN1Type.berEncode()};
            parts[part] = new BERConstructed(128, 0, contents);
        } else if (this.cOctetAligned != null) {
            parts[part] = this.cOctetAligned.berEncode(128, 1);
        } else if (this.cArbitrary != null) {
            parts[part] = this.cArbitrary.berEncode(128, 2);
        }
        return new BERConstructed(tagType, tag, parts);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean hasElement = false;
        if (this.sDirectReference != null) {
            str.append("directReference ");
            str.append(this.sDirectReference);
            hasElement = true;
        }
        if (this.sIndirectReference != null) {
            if (hasElement) {
                str.append(", ");
            }
            str.append("indirectReference ");
            str.append(this.sIndirectReference);
            hasElement = true;
        }
        if (this.sDataValueDescriptor != null) {
            if (hasElement) {
                str.append(", ");
            }
            str.append("dataValueDescriptor ");
            str.append(this.sDataValueDescriptor);
            hasElement = true;
        }
        if (hasElement) {
            str.append(", ");
        }
        str.append("encoding {");
        if (this.cSingleASN1Type != null) {
            str.append("singleASN1type ");
            str.append(this.cSingleASN1Type);
        }
        if (this.cOctetAligned != null) {
            str.append("octetAligned ");
            str.append(this.cOctetAligned);
        }
        if (this.cArbitrary != null) {
            str.append("arbitrary ");
            str.append(this.cArbitrary);
        }
        str.append("}}");
        return str.toString();
    }
}

