/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1ObjectIdentifier
extends ASN1Any {
    public static final int OBJECT_IDENTIFIER_TAG = 6;
    private int[] oid;

    public ASN1ObjectIdentifier(int[] oidValue) {
        this.oid = oidValue;
    }

    public ASN1ObjectIdentifier(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        int index;
        if (checkTag && (berEncoding.getTag() != 6 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.getTag() + " expected " + 6 + "\n");
        }
        if (!(berEncoding instanceof BERPrimitive)) {
            throw new ASN1EncodingException("bad form, constructed");
        }
        BERPrimitive ber = (BERPrimitive)berEncoding;
        int[] encoding = ber.getContentOctets();
        if (encoding.length < 2) {
            throw new ASN1EncodingException("invalid encoding, length = " + encoding.length);
        }
        int numComponents = 2;
        for (index = 1; index < encoding.length; ++index) {
            if ((encoding[index] & 0x80) != 0) continue;
            ++numComponents;
        }
        this.oid = new int[numComponents];
        this.oid[0] = encoding[0] / 40;
        this.oid[1] = encoding[0] % 40;
        index = 1;
        int component = 2;
        while (component < numComponents) {
            int octet;
            this.oid[component] = 0;
            do {
                octet = encoding[index++];
                int n = component;
                this.oid[n] = this.oid[n] << 7;
                int n2 = component++;
                this.oid[n2] = this.oid[n2] | octet & 0x7F;
            } while ((octet & 0x80) != 0);
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 6);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        if (this.oid.length < 2) {
            throw new ASN1Exception("less than 2 components, violates X.208");
        }
        if (this.oid[0] < 0 || 2 < this.oid[0]) {
            throw new ASN1Exception("First component invalid, value = " + this.oid[0]);
        }
        if (this.oid[1] < 0 || 39 < this.oid[1]) {
            throw new ASN1Exception("Second component invalid, value = " + this.oid[1]);
        }
        int numBytes = 1;
        for (int index = 2; index < this.oid.length; ++index) {
            int tmpValue = this.oid[index];
            if (tmpValue < 0) {
                throw new ASN1Exception("component " + (index + 1) + " is negative, value = " + tmpValue);
            }
            do {
                ++numBytes;
            } while ((tmpValue >>= 7) != 0);
        }
        int[] octets = new int[numBytes];
        octets[0] = 40 * this.oid[0] + this.oid[1];
        int bcount = 0;
        for (int index = 2; index < this.oid.length; ++index) {
            int numberBytes = 0;
            int tmpValue = this.oid[index];
            do {
                ++numberBytes;
            } while ((tmpValue >>= 7) != 0);
            tmpValue = this.oid[index];
            for (int digit = numberBytes - 1; 0 <= digit; --digit) {
                octets[++bcount] = tmpValue >> digit * 7 & 0x7F;
                if (digit == 0) continue;
                int n = bcount;
                octets[n] = octets[n] | 0x80;
            }
        }
        return new BERPrimitive(tagType, tag, octets);
    }

    public ASN1ObjectIdentifier set(int[] newVal) {
        this.oid = newVal;
        return this;
    }

    public int[] get() {
        return this.oid;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int index = 0; index < this.oid.length; ++index) {
            if (index != 0) {
                str.append('.');
            }
            str.append(String.valueOf(this.oid[index]));
        }
        return new String(str);
    }
}

