/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1.io;

import java.io.IOException;
import java.io.OutputStream;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;
import org.xbib.asn1.io.BERWriter;

public class OutputStreamBERWriter
implements BERWriter {
    private final OutputStream outputStream;
    private final boolean autoflush;

    public OutputStreamBERWriter(OutputStream outputStream) {
        this(outputStream, true);
    }

    public OutputStreamBERWriter(OutputStream outputStream, boolean autoflush) {
        this.outputStream = outputStream;
        this.autoflush = autoflush;
    }

    @Override
    public void write(BEREncoding ber) throws IOException {
        if (ber instanceof BERPrimitive) {
            this.writeBERPrimitive((BERPrimitive)ber);
        } else if (ber instanceof BERConstructed) {
            this.writeBERConstructed((BERConstructed)ber);
        }
        if (this.autoflush) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    private void writeBERConstructed(BERConstructed ber) throws IOException {
        this.outputHead(ber);
        for (BEREncoding contentElement : ber.getContentElements()) {
            this.write(contentElement);
        }
    }

    private void writeBERPrimitive(BERPrimitive ber) throws IOException {
        this.outputHead(ber);
        this.outputBytes(ber.getContentOctets());
    }

    private void outputHead(BEREncoding ber) throws IOException {
        this.outputBytes(ber.getIdentifierEncoding());
        this.outputBytes(ber.getLengthEncoding());
    }

    private void outputBytes(int[] data) throws IOException {
        for (int aData : data) {
            this.outputStream.write(aData);
        }
    }
}

