/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1Boolean
extends ASN1Any {
    public static final int TAG = 1;
    private boolean value;

    public ASN1Boolean(boolean bool) {
        this.value = bool;
    }

    public ASN1Boolean(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        int[] encoding;
        if (checkTag && (berEncoding.getTag() != 1 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("ASN.1 BOOLEAN: bad BER: tag=" + berEncoding.getTag() + " expected TAG\n");
        }
        if (berEncoding instanceof BERPrimitive) {
            BERPrimitive ber = (BERPrimitive)berEncoding;
            encoding = ber.getContentOctets();
            if (encoding.length != 1) {
                throw new ASN1EncodingException("ASN.1 BOOLEAN: invalid encoding, length = " + encoding.length);
            }
        } else {
            throw new ASN1EncodingException("ASN.1 BOOLEAN: bad BER: decoding constructed NOT IMPLEMENTED YET");
        }
        this.value = encoding[0] != 0;
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 1);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int[] encoding = new int[]{this.value ? 255 : 0};
        return new BERPrimitive(tagType, tag, encoding);
    }

    public ASN1Boolean set(boolean newVal) {
        this.value = newVal;
        return this;
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }
}

