/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import java.nio.charset.StandardCharsets;
import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public class ASN1OctetString
extends ASN1Any {
    public static final int OCTET_STRING_TAG = 4;
    private static final char[] oct = new char[]{'0', '1', '2', '3', '4', '5', '6', '7'};
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private byte[] octets;

    public ASN1OctetString(byte[] data) {
        this.octets = new byte[data.length];
        System.arraycopy(data, 0, this.octets, 0, data.length);
    }

    public ASN1OctetString(String str) {
        this.octets = str.getBytes(StandardCharsets.ISO_8859_1);
    }

    public ASN1OctetString(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        StringBuilder buf;
        if (checkTag && (berEncoding.getTag() != 4 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.getTag() + " expected 4\n");
        }
        if (berEncoding instanceof BERPrimitive) {
            BERPrimitive ber = (BERPrimitive)berEncoding;
            int[] encoding = ber.getContentOctets();
            buf = new StringBuilder(encoding.length);
            for (int anEncoding : encoding) {
                buf.append((char)(anEncoding & 0xFF));
            }
        } else {
            throw new ASN1EncodingException("decode from constructed NOT IMPLEMENTED YET");
        }
        this.octets = buf.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 4);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int size = this.octets.length;
        int[] encoding = new int[size];
        for (int index = 0; index < size; ++index) {
            encoding[index] = this.octets[index] & 0xFF;
        }
        return new BERPrimitive(tagType, tag, encoding);
    }

    public ASN1OctetString set(byte[] octetArray) {
        this.octets = new byte[octetArray.length];
        System.arraycopy(octetArray, 0, this.octets, 0, octetArray.length);
        return this;
    }

    public ASN1OctetString set(String str) {
        this.octets = str.getBytes(StandardCharsets.ISO_8859_1);
        return this;
    }

    public String get() {
        return new String(this.octets, StandardCharsets.ISO_8859_1);
    }

    public byte[] getBytes() {
        return this.octets;
    }

    @Override
    public String toString() {
        char octet;
        int size = this.octets.length;
        StringBuilder buf = new StringBuilder(32 + size * 4);
        int printable = 0;
        int binary = 0;
        for (byte octet1 : this.octets) {
            octet = (char)octet1;
            if (' ' <= octet && octet <= '~' || octet == '\n') {
                ++printable;
                continue;
            }
            ++binary;
        }
        if (binary <= printable) {
            buf.append('\"');
            for (byte octet1 : this.octets) {
                octet = (char)octet1;
                if (' ' <= octet && octet <= '~') {
                    if (octet == '\\' || octet == '\"' || octet == '\'') {
                        buf.append('\\');
                    }
                    buf.append(octet);
                    continue;
                }
                if (octet == '\n') {
                    buf.append("\\n");
                    continue;
                }
                if (octet == '\t') {
                    buf.append("\\t");
                    continue;
                }
                if (octet == '\r') {
                    buf.append("\\r");
                    continue;
                }
                if (octet == '\b') {
                    buf.append("\\b");
                    continue;
                }
                if (octet == '\f') {
                    buf.append("\\f");
                    continue;
                }
                buf.append('\\');
                buf.append(oct[octet >> 6 & 7]);
                buf.append(oct[octet >> 3 & 7]);
                buf.append(oct[octet & 7]);
            }
            buf.append('\"');
        } else {
            buf.append('\'');
            for (byte octet1 : this.octets) {
                octet = (char)octet1;
                buf.append(hex[octet >> 4 & 0xF]);
                buf.append(hex[octet & 0xF]);
            }
            buf.append("'H");
        }
        return buf.toString();
    }
}

