/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Exception;

public abstract class BEREncoding {
    public static final int UNIVERSAL_TAG = 0;
    public static final int APPLICATION_TAG = 64;
    public static final int CONTEXT_SPECIFIC_TAG = 128;
    public static final int PRIVATE_TAG = 192;
    protected int tagType;
    protected int tag;
    protected int totalLength;
    private int[] identifierEncoding;
    private int[] lengthEncoding;

    public int[] getIdentifierEncoding() {
        return this.identifierEncoding;
    }

    public int[] getLengthEncoding() {
        return this.lengthEncoding;
    }

    public int getTagType() {
        return this.tagType;
    }

    public int getTag() {
        return this.tag;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    protected void init(int tagType, boolean isConstructed, int tag, int length) throws ASN1Exception {
        this.makeIdentifier(tagType, isConstructed, tag);
        this.makeLength(length);
        this.totalLength = this.identifierEncoding.length + this.lengthEncoding.length + length;
    }

    protected int getHead(int offset, byte[] data) {
        for (int anIdentifierEncoding : this.identifierEncoding) {
            data[offset++] = (byte)anIdentifierEncoding;
        }
        for (int aLengthEncoding : this.lengthEncoding) {
            data[offset++] = (byte)aLengthEncoding;
        }
        return offset;
    }

    protected abstract int getEncoding(int var1, byte[] var2);

    private void makeIdentifier(int tagType, boolean isConstructed, int tag) throws ASN1Exception {
        if ((tagType & 0xFFFFFF3F) != 0) {
            throw new ASN1Exception("Invalid ASN.1 tag type");
        }
        if (tag < 0) {
            throw new ASN1Exception("ASN.1 tag value is negative");
        }
        int b = this.tagType = tagType & 0xC0;
        if (isConstructed) {
            b |= 0x20;
        }
        this.tag = tag;
        if (tag <= 30) {
            this.identifierEncoding = new int[1];
            this.identifierEncoding[0] = b |= tag & 0x1F;
        } else {
            b |= 0x1F;
            int numberBytes = 1;
            int tmpTag = tag;
            do {
                ++numberBytes;
            } while ((tmpTag >>= 7) != 0);
            this.identifierEncoding = new int[numberBytes];
            this.identifierEncoding[0] = b;
            int index = 0;
            for (int digit = numberBytes - 2; 0 <= digit; --digit) {
                this.identifierEncoding[++index] = tag >> digit * 7 & 0x7F;
                if (digit == 0) continue;
                int n = index;
                this.identifierEncoding[n] = this.identifierEncoding[n] | 0x80;
            }
        }
    }

    private void makeLength(int length) {
        if (length < 0) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = 128;
        } else if (length < 128) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = length;
        } else {
            int count = 0;
            for (int shifted = length; shifted != 0; shifted >>= 8) {
                ++count;
            }
            this.lengthEncoding = new int[count + 1];
            this.lengthEncoding[0] = count | 0x80;
            int index = 0;
            while (0 < count) {
                int digit = length >> --count * 8 & 0xFF;
                this.lengthEncoding[++index] = digit;
            }
        }
    }
}

