/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;
import org.xbib.asn1.io.BERReader;

public class InputStreamBERReader
implements BERReader {
    private static final String ERROR = "Unexpected end in BER encoding";
    private static final int MAX_BER_SIZE = 262144;
    private final InputStream inputStream;

    public InputStreamBERReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public BEREncoding read() throws IOException {
        int[] numBytesRead = new int[]{0};
        return this.doInput(numBytesRead);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private BEREncoding doInput(int[] numBytesRead) throws IOException {
        int length;
        int tag;
        int octet = this.inputStream.read();
        if (octet < 0) {
            return null;
        }
        numBytesRead[0] = numBytesRead[0] + 1;
        int tagType = octet & 0xC0;
        boolean isCons = false;
        if ((octet & 0x20) != 0) {
            isCons = true;
        }
        if ((tag = octet & 0x1F) == 31) {
            tag = 0;
            do {
                if ((octet = this.inputStream.read()) < 0) {
                    throw new ASN1EncodingException(ERROR);
                }
                numBytesRead[0] = numBytesRead[0] + 1;
                tag <<= 7;
                tag |= octet & 0x7F;
            } while ((octet & 0x80) != 0);
        }
        if ((octet = this.inputStream.read()) < 0) {
            throw new ASN1EncodingException(ERROR);
        }
        numBytesRead[0] = numBytesRead[0] + 1;
        if ((octet & 0x80) != 0) {
            if ((octet & 0x7F) == 0) {
                length = -1;
                if (!isCons) {
                    throw new ASN1EncodingException("BER encoding corrupted primitive");
                }
            } else {
                if (4 < (octet & 0x7F)) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
                length = 0;
                for (int numBytes = octet & 0x7F; 0 < numBytes; --numBytes) {
                    octet = this.inputStream.read();
                    if (octet < 0) {
                        throw new ASN1EncodingException(ERROR);
                    }
                    numBytesRead[0] = numBytesRead[0] + 1;
                    length <<= 8;
                    length |= octet & 0xFF;
                }
                if (length < 0 || 262144 < length) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
            }
        } else {
            length = octet & 0x7F;
        }
        if (!isCons) {
            int[] contents = new int[length];
            for (int x = 0; x < length; ++x) {
                octet = this.inputStream.read();
                if (octet < 0) {
                    throw new ASN1EncodingException(ERROR);
                }
                numBytesRead[0] = numBytesRead[0] + 1;
                contents[x] = octet;
            }
            return new BERPrimitive(tagType, tag, contents);
        }
        ArrayList<BEREncoding> chunks = new ArrayList<BEREncoding>();
        if (0 <= length) {
            int currentRead;
            for (int totalRead = 0; totalRead < length; totalRead += numBytesRead[0] - currentRead) {
                currentRead = numBytesRead[0];
                BEREncoding chunk = this.doInput(numBytesRead);
                if (chunk == null) {
                    throw new ASN1EncodingException(ERROR);
                }
                chunks.add(chunk);
            }
        } else {
            while (true) {
                BEREncoding chunk;
                if ((chunk = this.doInput(numBytesRead)) == null) {
                    throw new ASN1EncodingException(ERROR);
                }
                if (chunk.getTag() == 0 && chunk.getTagType() == 0 && chunk.getTotalLength() == 2) break;
                chunks.add(chunk);
            }
        }
        int numElements = chunks.size();
        BEREncoding[] parts = new BEREncoding[numElements];
        for (int x = 0; x < numElements; ++x) {
            parts[x] = (BEREncoding)chunks.get(x);
        }
        return new BERConstructed(tagType, tag, parts);
    }
}

