/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1BitString
extends ASN1Any {
    public static final int BIT_STRING_TAG = 3;
    private boolean[] bits;

    public ASN1BitString(boolean[] bitValues) {
        this.bits = bitValues;
    }

    public ASN1BitString(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        if (checkTag && (berEncoding.getTag() != 3 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("ASN.1 BIT STRING: bad BER: tag=" + berEncoding.getTag() + " expected 3\n");
        }
        if (berEncoding instanceof BERPrimitive) {
            BERPrimitive ber = (BERPrimitive)berEncoding;
            int[] encoding = ber.getContentOctets();
            if (encoding.length < 1) {
                throw new ASN1EncodingException("ASN1 BIT STRING: invalid encoding, length = " + encoding.length);
            }
            int unusedBits = encoding[0] & 7;
            int numBits = (encoding.length - 1) * 8 - unusedBits;
            this.bits = new boolean[numBits];
            for (int bit = 0; bit < numBits; ++bit) {
                int octet = encoding[bit / 8 + 1];
                this.bits[bit] = ((octet <<= bit % 8) & 0x80) != 0;
            }
        } else {
            throw new ASN1EncodingException("ASN.1 BIT STRING: decoding constructed NOT IMPLEMENTED YET");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 3);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numOctets = (this.bits.length + 7) / 8;
        int[] encoding = new int[numOctets + 1];
        encoding[0] = numOctets * 8 - this.bits.length;
        for (int count = 1; count <= numOctets; ++count) {
            encoding[count] = 0;
            int bitBaseIndex = (count - 1) * 8;
            for (int bitIndex = 0; bitIndex < 8; ++bitIndex) {
                int n = bitBaseIndex + bitIndex;
                int n2 = count;
                encoding[n2] = encoding[n2] << 1;
                if (n >= this.bits.length || !this.bits[n]) continue;
                int n3 = count;
                encoding[n3] = encoding[n3] | 1;
            }
        }
        return new BERPrimitive(tagType, tag, encoding);
    }

    public ASN1BitString set(boolean[] newBits) {
        this.bits = newBits;
        return this;
    }

    public boolean[] get() {
        return this.bits;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('\'');
        for (boolean bit : this.bits) {
            str.append(bit ? (char)'1' : '0');
        }
        str.append("'B");
        return str.toString();
    }
}

