/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BEREncoding;
import org.xbib.asn1.BERPrimitive;

public final class ASN1Null
extends ASN1Any {
    public static final int NULL_TAG = 5;

    public ASN1Null() {
    }

    public ASN1Null(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    @Override
    public void berDecode(BEREncoding berEncoding, boolean checkTag) throws ASN1EncodingException {
        if (checkTag && (berEncoding.getTag() != 5 || berEncoding.getTagType() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + berEncoding.getTag() + " expected 5\n");
        }
        if (!(berEncoding instanceof BERPrimitive)) {
            throw new ASN1EncodingException("bad form, constructed");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 5);
    }

    @Override
    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int[] encoding = new int[]{};
        return new BERPrimitive(tagType, tag, encoding);
    }

    @Override
    public String toString() {
        return "null";
    }
}

