/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;

public class ASN1GeneralString
extends ASN1OctetString {
    public static final int GENERAL_STRING_TAG = 27;

    public ASN1GeneralString(String value) {
        super(value);
    }

    public ASN1GeneralString(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, false);
        if (checkTag && (ber.getTag() != 27 || ber.getTagType() != 0)) {
            throw new ASN1EncodingException("bad BER: tag=" + ber.getTag() + " expected 27\n");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 27);
    }
}

