/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.asn1;

import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1GraphicString;
import org.xbib.asn1.BEREncoding;

public final class ASN1ObjectDescriptor
extends ASN1GraphicString {
    public static final int OBJECT_DESCRIPTOR_TAG = 7;

    public ASN1ObjectDescriptor(String descriptor) {
        super(descriptor);
    }

    public ASN1ObjectDescriptor(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, false);
        if (checkTag && (ber.getTag() != 7 || ber.getTagType() != 0)) {
            throw new ASN1EncodingException("ASN.1 ObjectDescriptor: bad BER: tag=" + ber.getTag() + " expected 7\n");
        }
    }

    @Override
    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 7);
    }
}

