// Output created by jacc 2.1.0
package org.xbib.z3950.common.pqf;

import java.io.Reader;
import java.io.IOException;

/**

Mike Taylor, IndexData:

"Prefix Query Format (PQF), also known as
Prefix Query Notation (PQN) was defined in 1995, as part of the YAZ
toolkit, and has since become the de facto standard representation of
RPN queries."

 From: http://www.indexdata.com/yaz/doc/tools.tkl#PQF

 The grammar of the PQF is as follows:

     query ::= top-set query-struct.

     top-set ::= [ '@attrset' string ]

     query-struct ::= attr-spec | simple | complex | '@term' term-type query

     attr-spec ::= '@attr' [ string ] string query-struct

     complex ::= operator query-struct query-struct.

     operator ::= '@and' | '@or' | '@not' | '@prox' proximity.

     simple ::= result-set | term.

     result-set ::= '@set' string.

     term ::= string.

     proximity ::= exclusion distance ordered relation which-code unit-code.

     exclusion ::= '1' | '0' | 'void'.

     distance ::= integer.

     ordered ::= '1' | '0'.

     relation ::= integer.

     which-code ::= 'known' | 'private' | integer.

     unit-code ::= integer.

     term-type ::= 'general' | 'numeric' | 'string' | 'oid' | 'datetime' | 'null'.
    

 You will note that the syntax above is a fairly faithful representation of RPN, 
 except for the Attribute, which has been moved a step away from the term, 
 allowing you to associate one or more attributes with an entire query structure. 
 The parser will automatically apply the given attributes to each term as required.

 The @attr operator is followed by an attribute specification (attr-spec above). 
 The specification consists of an optional attribute set, an attribute 
 type-value pair and a sub-query. The attribute type-value pair is packed 
 in one string: an attribute type, an equals sign, and an attribute value, 
 like this: @attr 1=1003. The type is always an integer but the value may be 
 either an integer or a string (if it doesn't start with a digit character). 
 A string attribute-value is encoded as a Type-1 ``complex'' attribute with 
 the list of values containing the single string specified, and including 
 no semantic indicators. 

*/


public class PQFParser implements PQFTokens {
    private int yyss = 100;
    private int yytok;
    private int yysp = 0;
    private int[] yyst;
    protected int yyerrno = (-1);
    private Object[] yysv;
    private Object yyrv;

    public boolean parse() {
        int yyn = 0;
        yysp = 0;
        yyst = new int[yyss];
        yysv = new Object[yyss];
        yytok = (lexer.getToken()
                 );
    loop:
        for (;;) {
            switch (yyn) {
                case 0:
                    yyst[yysp] = 0;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 38:
                    yyn = yys0();
                    continue;

                case 1:
                    yyst[yysp] = 1;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 39:
                    switch (yytok) {
                        case ENDINPUT:
                            yyn = 76;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 2:
                    yyst[yysp] = 2;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 40:
                    yyn = yys2();
                    continue;

                case 3:
                    yyst[yysp] = 3;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 41:
                    yyn = yys3();
                    continue;

                case 4:
                    yyst[yysp] = 4;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 42:
                    yyn = yys4();
                    continue;

                case 5:
                    yyst[yysp] = 5;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 43:
                    yyn = yys5();
                    continue;

                case 6:
                    yyst[yysp] = 6;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 44:
                    yyn = yys6();
                    continue;

                case 7:
                    yyst[yysp] = 7;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 45:
                    yyn = yys7();
                    continue;

                case 8:
                    yyst[yysp] = 8;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 46:
                    yyn = yys8();
                    continue;

                case 9:
                    yyst[yysp] = 9;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 47:
                    yyn = yys9();
                    continue;

                case 10:
                    yyst[yysp] = 10;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 48:
                    switch (yytok) {
                        case CHARSTRING1:
                            yyn = 20;
                            continue;
                        case INTEGER:
                            yyn = 21;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 11:
                    yyst[yysp] = 11;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 49:
                    switch (yytok) {
                        case CHARSTRING1:
                            yyn = 22;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 12:
                    yyst[yysp] = 12;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 50:
                    yyn = yys12();
                    continue;

                case 13:
                    yyst[yysp] = 13;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 51:
                    yyn = yys13();
                    continue;

                case 14:
                    yyst[yysp] = 14;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 52:
                    yyn = yys14();
                    continue;

                case 15:
                    yyst[yysp] = 15;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 53:
                    yyn = yys15();
                    continue;

                case 16:
                    yyst[yysp] = 16;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 54:
                    switch (yytok) {
                        case CHARSTRING1:
                            yyn = 25;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 17:
                    yyst[yysp] = 17;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 55:
                    switch (yytok) {
                        case TERMTYPE:
                            yyn = 26;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 18:
                    yyst[yysp] = 18;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 56:
                    yyn = yys18();
                    continue;

                case 19:
                    yyst[yysp] = 19;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 57:
                    yyn = yys19();
                    continue;

                case 20:
                    yyst[yysp] = 20;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 58:
                    switch (yytok) {
                        case INTEGER:
                            yyn = 21;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 21:
                    yyst[yysp] = 21;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 59:
                    switch (yytok) {
                        case EQUALS:
                            yyn = 30;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 22:
                    yyst[yysp] = 22;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 60:
                    yyn = yys22();
                    continue;

                case 23:
                    yyst[yysp] = 23;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 61:
                    yyn = yys23();
                    continue;

                case 24:
                    yyst[yysp] = 24;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 62:
                    yyn = yys24();
                    continue;

                case 25:
                    yyst[yysp] = 25;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 63:
                    yyn = yys25();
                    continue;

                case 26:
                    yyst[yysp] = 26;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 64:
                    yyn = yys26();
                    continue;

                case 27:
                    yyst[yysp] = 27;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 65:
                    yyn = yys27();
                    continue;

                case 28:
                    yyst[yysp] = 28;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 66:
                    yyn = yys28();
                    continue;

                case 29:
                    yyst[yysp] = 29;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 67:
                    yyn = yys29();
                    continue;

                case 30:
                    yyst[yysp] = 30;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 68:
                    switch (yytok) {
                        case CHARSTRING1:
                            yyn = 36;
                            continue;
                        case INTEGER:
                            yyn = 37;
                            continue;
                    }
                    yyn = 79;
                    continue;

                case 31:
                    yyst[yysp] = 31;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 69:
                    yyn = yys31();
                    continue;

                case 32:
                    yyst[yysp] = 32;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 70:
                    yyn = yys32();
                    continue;

                case 33:
                    yyst[yysp] = 33;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 71:
                    yyn = yys33();
                    continue;

                case 34:
                    yyst[yysp] = 34;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 72:
                    yyn = yys34();
                    continue;

                case 35:
                    yyst[yysp] = 35;
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 73:
                    yyn = yys35();
                    continue;

                case 36:
                    yyst[yysp] = 36;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 74:
                    yyn = yys36();
                    continue;

                case 37:
                    yyst[yysp] = 37;
                    yysv[yysp] = (lexer.getSemantic()
                                 );
                    yytok = (lexer.nextToken()
                            );
                    if (++yysp>=yyst.length) {
                        yyexpand();
                    }
                case 75:
                    yyn = yys37();
                    continue;

                case 76:
                    return true;
                case 77:
                    yyerror("stack overflow");
                case 78:
                    return false;
                case 79:
                    yyerror("syntax error");
                    return false;
            }
        }
    }

    protected void yyexpand() {
        int[] newyyst = new int[2*yyst.length];
        Object[] newyysv = new Object[2*yyst.length];
        for (int i=0; i<yyst.length; i++) {
            newyyst[i] = yyst[i];
            newyysv[i] = yysv[i];
        }
        yyst = newyyst;
        yysv = newyysv;
    }

    private int yys0() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case ATTRSET:
                return 11;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys2() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr5();
        }
        return 79;
    }

    private int yys3() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr11();
        }
        return 79;
    }

    private int yys4() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr3();
        }
        return 79;
    }

    private int yys5() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr2();
        }
        return 79;
    }

    private int yys6() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr9();
        }
        return 79;
    }

    private int yys7() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr4();
        }
        return 79;
    }

    private int yys8() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr10();
        }
        return 79;
    }

    private int yys9() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys12() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr13();
        }
        return 79;
    }

    private int yys13() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr14();
        }
        return 79;
    }

    private int yys14() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys15() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys18() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys19() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys22() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys23() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys24() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys25() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr12();
        }
        return 79;
    }

    private int yys26() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case ATTRSET:
                return 11;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys27() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr17();
        }
        return 79;
    }

    private int yys28() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr7();
        }
        return 79;
    }

    private int yys29() {
        switch (yytok) {
            case AND:
                return 9;
            case ATTR:
                return 10;
            case CHARSTRING1:
                return 12;
            case CHARSTRING2:
                return 13;
            case NOT:
                return 14;
            case OR:
                return 15;
            case SET:
                return 16;
            case TERM:
                return 17;
        }
        return 79;
    }

    private int yys31() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr1();
        }
        return 79;
    }

    private int yys32() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr19();
        }
        return 79;
    }

    private int yys33() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr18();
        }
        return 79;
    }

    private int yys34() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr6();
        }
        return 79;
    }

    private int yys35() {
        switch (yytok) {
            case SET:
            case OR:
            case NOT:
            case TERM:
            case CHARSTRING2:
            case ENDINPUT:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr8();
        }
        return 79;
    }

    private int yys36() {
        switch (yytok) {
            case SET:
            case OR:
            case TERM:
            case NOT:
            case CHARSTRING2:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr16();
        }
        return 79;
    }

    private int yys37() {
        switch (yytok) {
            case SET:
            case OR:
            case TERM:
            case NOT:
            case CHARSTRING2:
            case CHARSTRING1:
            case ATTR:
            case AND:
                return yyr15();
        }
        return 79;
    }

    private int yyr1() { // pqf : ATTRSET CHARSTRING1 querystruct
        {
        this.pqf = new PQF(((String)yysv[yysp-2]), ((Query)yysv[yysp-1])); 
        yyrv = this.pqf;
    }
        yysv[yysp-=3] = yyrv;
        return yyppqf();
    }

    private int yyr2() { // pqf : querystruct
        {
        this.pqf = new PQF(((Query)yysv[yysp-1])); 
        yyrv = this.pqf;
    }
        yysv[yysp-=1] = yyrv;
        return yyppqf();
    }

    private int yyppqf() {
        switch (yyst[yysp-1]) {
            case 0: return 1;
            default: return 34;
        }
    }

    private int yyr15() { // attrstr : INTEGER EQUALS INTEGER
        {
        yyrv = new AttrStr(((Integer)yysv[yysp-3]), ((Integer)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return yypattrstr();
    }

    private int yyr16() { // attrstr : INTEGER EQUALS CHARSTRING1
        {
        yyrv = new AttrStr(((Integer)yysv[yysp-3]), ((String)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return yypattrstr();
    }

    private int yypattrstr() {
        switch (yyst[yysp-1]) {
            case 10: return 19;
            default: return 29;
        }
    }

    private int yyr11() { // complex : expression
        {
         yyrv = new Query(((Expression)yysv[yysp-1]));
    }
        yysv[yysp-=1] = yyrv;
        return 2;
    }

    private int yyr17() { // expression : AND querystruct querystruct
        {
        yyrv = new Expression(((String)yysv[yysp-3]), ((Query)yysv[yysp-2]), ((Query)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return 3;
    }

    private int yyr18() { // expression : OR querystruct querystruct
        {
        yyrv = new Expression(((String)yysv[yysp-3]), ((Query)yysv[yysp-2]), ((Query)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return 3;
    }

    private int yyr19() { // expression : NOT querystruct querystruct
        {
        yyrv = new Expression(((String)yysv[yysp-3]), ((Query)yysv[yysp-2]), ((Query)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return 3;
    }

    private int yyr7() { // attrspec : ATTR attrstr querystruct
        {
        yyrv = new Query(((AttrStr)yysv[yysp-2]), ((Query)yysv[yysp-1]));
    }
        yysv[yysp-=3] = yyrv;
        return 4;
    }

    private int yyr8() { // attrspec : ATTR CHARSTRING1 attrstr querystruct
        {
        yyrv = new Query(((String)yysv[yysp-3]), ((AttrStr)yysv[yysp-2]), ((Query)yysv[yysp-1]));
    }
        yysv[yysp-=4] = yyrv;
        return 4;
    }

    private int yyr3() { // querystruct : attrspec
        yysp -= 1;
        return yypquerystruct();
    }

    private int yyr4() { // querystruct : simple
        yysp -= 1;
        return yypquerystruct();
    }

    private int yyr5() { // querystruct : complex
        yysp -= 1;
        return yypquerystruct();
    }

    private int yyr6() { // querystruct : TERM TERMTYPE pqf
        {
        yyrv = new Query(((PQF)yysv[yysp-1]));
}
        yysv[yysp-=3] = yyrv;
        return yypquerystruct();
    }

    private int yypquerystruct() {
        switch (yyst[yysp-1]) {
            case 29: return 35;
            case 24: return 33;
            case 23: return 32;
            case 22: return 31;
            case 19: return 28;
            case 18: return 27;
            case 15: return 24;
            case 14: return 23;
            case 9: return 18;
            default: return 5;
        }
    }

    private int yyr12() { // resultset : SET CHARSTRING1
        {
        yyrv = new Setname(((String)yysv[yysp-1]));
    }
        yysv[yysp-=2] = yyrv;
        return 6;
    }

    private int yyr9() { // simple : resultset
        {
         yyrv = new Query(((Setname)yysv[yysp-1]));
    }
        yysv[yysp-=1] = yyrv;
        return 7;
    }

    private int yyr10() { // simple : term
        {
         yyrv = new Query(((Term)yysv[yysp-1]));
    }
        yysv[yysp-=1] = yyrv;
        return 7;
    }

    private int yyr13() { // term : CHARSTRING1
        {
        yyrv = new Term(((String)yysv[yysp-1]));
    }
        yysv[yysp-=1] = yyrv;
        return 8;
    }

    private int yyr14() { // term : CHARSTRING2
        {
        yyrv = new Term(((String)yysv[yysp-1]));
    }
        yysv[yysp-=1] = yyrv;
        return 8;
    }

    protected String[] yyerrmsgs = {
    };


    private PQFLexer lexer;
        
    private PQF pqf;
        
    public PQFParser(Reader r) {
        this.lexer = new PQFLexer(r);
        lexer.nextToken();
    }

    public void yyerror(String error) {
        throw new SyntaxException("PQF error at " 
            + "[" + lexer.getLine() + "," + lexer.getColumn() +"]"
            + ": " +  error);
    }
    
    public PQF getResult()
    {
        return pqf;
    }


}
