/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.cql;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.cql.BooleanGroup;
import org.xbib.cql.BooleanOperator;
import org.xbib.cql.Identifier;
import org.xbib.cql.Index;
import org.xbib.cql.Modifier;
import org.xbib.cql.ModifierList;
import org.xbib.cql.PrefixAssignment;
import org.xbib.cql.Query;
import org.xbib.cql.Relation;
import org.xbib.cql.ScopedClause;
import org.xbib.cql.SearchClause;
import org.xbib.cql.SimpleName;
import org.xbib.cql.SingleSpec;
import org.xbib.cql.SortSpec;
import org.xbib.cql.SortedQuery;
import org.xbib.cql.Visitor;
import org.xbib.z3950.common.cql.SyntaxException;
import org.xbib.z3950.common.v3.AttributeElement;
import org.xbib.z3950.common.v3.AttributeElementAttributeValue;
import org.xbib.z3950.common.v3.AttributeList;
import org.xbib.z3950.common.v3.AttributeSetId;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.Operand;
import org.xbib.z3950.common.v3.Operator;
import org.xbib.z3950.common.v3.RPNQuery;
import org.xbib.z3950.common.v3.RPNStructure;
import org.xbib.z3950.common.v3.RPNStructureRpnRpnOp;
import org.xbib.z3950.common.v3.Term;

public final class CQLRPNGenerator
implements Visitor {
    private final Map<String, ResourceBundle> contexts = new HashMap<String, ResourceBundle>(){
        private static final long serialVersionUID = 8199395368653216950L;
        {
            this.put("bib", ResourceBundle.getBundle("org.xbib.z3950.common.cql.bib-1"));
            this.put("dc", ResourceBundle.getBundle("org.xbib.z3950.common.cql.dc"));
            this.put("gbv", ResourceBundle.getBundle("org.xbib.z3950.common.cql.gbv"));
        }
    };
    private Stack<ASN1Any> result = new Stack();
    private RPNQuery rpnQuery;

    public RPNQuery getQueryResult() {
        return this.rpnQuery;
    }

    public void visit(SortedQuery node) {
        if (node.getSortSpec() != null) {
            node.getSortSpec().accept((Visitor)this);
        }
        if (node.getQuery() != null) {
            node.getQuery().accept((Visitor)this);
        }
        if (this.result.isEmpty()) {
            throw new SyntaxException("unable to generate RPN from CQL");
        }
        this.rpnQuery = new RPNQuery();
        this.rpnQuery.rpn = (RPNStructure)this.result.pop();
        this.rpnQuery.attributeSet = new AttributeSetId();
        this.rpnQuery.attributeSet.value = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 10003, 3, 1});
    }

    public void visit(Query node) {
        if (node.getPrefixAssignments() != null) {
            for (PrefixAssignment assignment : node.getPrefixAssignments()) {
                assignment.accept((Visitor)this);
            }
        }
        if (node.getQuery() != null) {
            node.getQuery().accept((Visitor)this);
        }
        if (node.getScopedClause() != null) {
            node.getScopedClause().accept((Visitor)this);
        }
    }

    public void visit(SortSpec node) {
        if (node.getSingleSpec() != null) {
            node.getSingleSpec().accept((Visitor)this);
        }
        if (node.getSortSpec() != null) {
            node.getSortSpec().accept((Visitor)this);
        }
    }

    public void visit(SingleSpec node) {
        if (node.getIndex() != null) {
            node.getIndex().accept((Visitor)this);
        }
        if (node.getModifierList() != null) {
            node.getModifierList().accept((Visitor)this);
        }
    }

    public void visit(PrefixAssignment node) {
        node.getPrefix().accept((Visitor)this);
        node.getURI().accept((Visitor)this);
    }

    public void visit(ScopedClause node) {
        if (node.getScopedClause() != null) {
            node.getScopedClause().accept((Visitor)this);
        }
        node.getSearchClause().accept((Visitor)this);
        if (node.getBooleanGroup() != null) {
            node.getBooleanGroup().accept((Visitor)this);
            RPNStructure rpn = new RPNStructure();
            rpn.c_rpnRpnOp = new RPNStructureRpnRpnOp();
            rpn.c_rpnRpnOp.s_op = new Operator();
            BooleanOperator op = node.getBooleanGroup().getOperator();
            switch (op) {
                case AND: {
                    rpn.c_rpnRpnOp.s_op.andOp = new ASN1Null();
                    break;
                }
                case OR: {
                    rpn.c_rpnRpnOp.s_op.orOp = new ASN1Null();
                    break;
                }
                case NOT: {
                    rpn.c_rpnRpnOp.s_op.andNotOp = new ASN1Null();
                    break;
                }
            }
            rpn.c_rpnRpnOp.s_rpn1 = (RPNStructure)this.result.pop();
            rpn.c_rpnRpnOp.s_rpn2 = (RPNStructure)this.result.pop();
            this.result.push(rpn);
        }
    }

    public void visit(BooleanGroup node) {
        if (node.getModifierList() != null) {
            node.getModifierList().accept((Visitor)this);
        }
    }

    public void visit(SearchClause node) {
        ASN1Any any;
        if (node.getQuery() != null) {
            node.getQuery().accept((Visitor)this);
        }
        if (node.getTerm() != null) {
            node.getTerm().accept((Visitor)this);
        }
        if (node.getIndex() != null) {
            node.getIndex().accept((Visitor)this);
        }
        if (node.getRelation() != null) {
            node.getRelation().accept((Visitor)this);
        }
        Operand operand = new Operand();
        operand.attrTerm = new AttributesPlusTerm();
        operand.attrTerm.term = new Term();
        operand.attrTerm.term.c_general = new ASN1OctetString(node.getTerm().getValue());
        Stack<AttributeElement> attrs = new Stack<AttributeElement>();
        ASN1Any aSN1Any = any = !this.result.isEmpty() && this.result.peek() instanceof AttributeElement ? this.result.pop() : null;
        while (any != null) {
            attrs.push((AttributeElement)any);
            any = !this.result.isEmpty() && this.result.peek() instanceof AttributeElement ? this.result.pop() : null;
        }
        operand.attrTerm.attributes = new AttributeList();
        operand.attrTerm.attributes.value = attrs.toArray(new AttributeElement[attrs.size()]);
        RPNStructure rpn = new RPNStructure();
        rpn.c_op = operand;
        this.result.push(rpn);
    }

    public void visit(Relation node) {
        if (node.getModifierList() != null) {
            node.getModifierList().accept((Visitor)this);
        }
        int t = 2;
        int n = 3;
        switch (node.getComparitor()) {
            case LESS: {
                n = 1;
                break;
            }
            case LESS_EQUALS: {
                n = 2;
                break;
            }
            case EQUALS: {
                n = 3;
                break;
            }
            case GREATER_EQUALS: {
                n = 4;
                break;
            }
            case GREATER: {
                n = 5;
                break;
            }
            case NOT_EQUALS: {
                n = 6;
                break;
            }
            case ALL: {
                t = 4;
                n = 6;
                break;
            }
            case ANY: {
                t = 4;
                n = 104;
                break;
            }
        }
        if (n != 3) {
            AttributeElement ae = new AttributeElement();
            ae.attributeType = new ASN1Integer(t);
            ae.attributeValue = new AttributeElementAttributeValue();
            ae.attributeValue.numeric = new ASN1Integer(n);
            this.result.push(ae);
        }
    }

    public void visit(Modifier node) {
        if (node.getTerm() != null) {
            node.getTerm().accept((Visitor)this);
        }
        if (node.getName() != null) {
            node.getName().accept((Visitor)this);
        }
    }

    public void visit(ModifierList node) {
        for (Modifier modifier : node.getModifierList()) {
            modifier.accept((Visitor)this);
        }
    }

    public void visit(org.xbib.cql.Term node) {
        int t = 5;
        int n = 100;
        String v = node.getValue();
        if (v.endsWith("*")) {
            n = v.startsWith("*") ? 3 : 1;
        } else if (v.startsWith("*")) {
            n = 2;
        }
        if (n != 100) {
            AttributeElement ae = new AttributeElement();
            ae.attributeType = new ASN1Integer(t);
            ae.attributeValue = new AttributeElementAttributeValue();
            ae.attributeValue.numeric = new ASN1Integer(n);
            this.result.push(ae);
            v = v.replaceAll("\\*", "");
        }
        ASN1OctetString s = new ASN1OctetString(v);
        this.result.push((ASN1Any)s);
    }

    public void visit(Identifier node) {
    }

    public void visit(SimpleName node) {
        ASN1OctetString s = new ASN1OctetString(node.getName());
        this.result.push((ASN1Any)s);
    }

    public void visit(Index node) {
        String context = node.getContext();
        if (context == null) {
            context = "dc";
        }
        int t = 1;
        int n = this.getUseAttr(context, node.getName());
        AttributeElement ae = new AttributeElement();
        ae.attributeType = new ASN1Integer(t);
        ae.attributeValue = new AttributeElementAttributeValue();
        ae.attributeValue.numeric = new ASN1Integer(n);
        this.result.push(ae);
    }

    private int getUseAttr(String context, String attrName) {
        try {
            return Integer.parseInt(this.contexts.get(context).getString(attrName));
        }
        catch (MissingResourceException e) {
            throw new SyntaxException("unknown use attribute '" + attrName + "' for context " + context, e);
        }
    }
}

