/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.operations;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.asn1.ASN1GeneralString;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.io.BERReader;
import org.xbib.asn1.io.BERWriter;
import org.xbib.z3950.api.ScanListener;
import org.xbib.z3950.common.operations.AbstractOperation;
import org.xbib.z3950.common.pqf.PQFParser;
import org.xbib.z3950.common.pqf.PQFRPNGenerator;
import org.xbib.z3950.common.v3.AttributeSetId;
import org.xbib.z3950.common.v3.AttributesPlusTerm;
import org.xbib.z3950.common.v3.DatabaseName;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.RPNQuery;
import org.xbib.z3950.common.v3.ScanRequest;
import org.xbib.z3950.common.v3.ScanResponse;

public class ScanOperation
extends AbstractOperation<ScanResponse, ScanRequest> {
    private static final Logger logger = Logger.getLogger(ScanOperation.class.getName());
    private final List<String> databases;

    public ScanOperation(BERReader reader, BERWriter writer, List<String> databases) {
        super(reader, writer);
        this.databases = databases;
    }

    public void executePQF(int nTerms, int step, int position, String pqf, ScanListener listener) throws IOException {
        this.execute(nTerms, step, position, this.createRPNQueryFromPQF((String)pqf).rpn.c_op.attrTerm, listener);
    }

    public void execute(int nTerms, int step, int position, AttributesPlusTerm term, ScanListener listener) throws IOException {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.attributeSet = new AttributeSetId();
        scanRequest.attributeSet.value = new ASN1ObjectIdentifier(new int[]{1, 2, 840, 10003, 3, 1});
        DatabaseName[] databaseNames = new DatabaseName[this.databases.size()];
        for (int n = 0; n < this.databases.size(); ++n) {
            databaseNames[n] = new DatabaseName();
            databaseNames[n].value = new InternationalString();
            databaseNames[n].value.value = new ASN1GeneralString(this.databases.get(n));
        }
        scanRequest.databaseNames = databaseNames;
        scanRequest.numberOfTermsRequested = new ASN1Integer(nTerms);
        scanRequest.stepSize = new ASN1Integer(step);
        scanRequest.preferredPositionInResponse = new ASN1Integer(position);
        scanRequest.termListAndStartPoint = term;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, scanRequest.toString());
        }
        this.write(scanRequest);
        ScanResponse scanResponse = (ScanResponse)((Object)this.read());
        if (scanResponse != null && scanResponse.scanStatus.get() == 0) {
            for (int n = 0; n < scanResponse.entries.s_entries.length; ++n) {
                if (listener == null) continue;
                listener.onScan(scanResponse.entries.s_entries[n].cTermInfo.berEncode());
            }
        }
    }

    private RPNQuery createRPNQueryFromPQF(String query) {
        PQFRPNGenerator generator = new PQFRPNGenerator();
        PQFParser parser = new PQFParser(new StringReader(query));
        parser.parse();
        parser.getResult().accept(generator);
        return generator.getResult();
    }
}

