/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.pqf;

import java.util.LinkedList;
import org.xbib.z3950.common.pqf.AttrStr;
import org.xbib.z3950.common.pqf.Expression;
import org.xbib.z3950.common.pqf.Node;
import org.xbib.z3950.common.pqf.PQF;
import org.xbib.z3950.common.pqf.Setname;
import org.xbib.z3950.common.pqf.Term;
import org.xbib.z3950.common.pqf.Visitor;

public class Query
extends Node {
    private String attrschema;
    private LinkedList<AttrStr> attrspec = new LinkedList();
    private Query querystruct;
    private Setname setname;
    private Term term;
    private Expression expr;
    private PQF pqf;

    public Query(String attrschema, AttrStr attrspec, Query querystruct) {
        this.attrschema = attrschema;
        this.attrspec.add(attrspec);
        this.querystruct = querystruct;
        this.term = querystruct.getTerm();
        this.attrspec.addAll(querystruct.getAttrSpec());
    }

    public Query(AttrStr attrspec, Query querystruct) {
        this.attrspec.add(attrspec);
        this.querystruct = querystruct;
        this.term = querystruct.getTerm();
        this.attrspec.addAll(querystruct.getAttrSpec());
    }

    public Query(PQF pqf) {
        this.pqf = pqf;
    }

    public Query(Term term) {
        this.term = term;
    }

    public Query(Expression expr) {
        this.expr = expr;
    }

    public Query(Setname setname) {
        this.setname = setname;
    }

    @Override
    public void accept(Visitor visitor) {
        if (this.term != null) {
            this.term.accept(visitor);
        }
        if (this.setname != null) {
            this.setname.accept(visitor);
        }
        if (this.expr != null) {
            this.expr.accept(visitor);
        }
        if (this.querystruct != null) {
            this.querystruct.accept(visitor);
        }
        for (AttrStr attr : this.attrspec) {
            attr.accept(visitor);
        }
        if (this.pqf != null) {
            this.pqf.accept(visitor);
        }
        visitor.visit(this);
    }

    public String getSchema() {
        return this.attrschema;
    }

    public Setname getSetname() {
        return this.setname;
    }

    public Term getTerm() {
        return this.term;
    }

    public LinkedList<AttrStr> getAttrSpec() {
        return this.attrspec;
    }

    public String toString() {
        return "[Query: term=" + this.term + " attrschema=" + this.attrschema + " setname=" + this.setname + " querystruct=" + this.querystruct + "]";
    }
}

