/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AccessControlRequestSecurityChallenge;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class AccessControlRequest
extends ASN1Any {
    public ReferenceId sReferenceId;
    public AccessControlRequestSecurityChallenge sSecurityChallenge;
    public OtherInformation sOtherInfo;

    public AccessControlRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("AccessControlRequest: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("AccessControlRequest: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.sReferenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sReferenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("AccessControlRequest: incomplete");
        }
        p = berConstructed.elementAt(part);
        this.sSecurityChallenge = new AccessControlRequestSecurityChallenge(p, true);
        this.sOtherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sOtherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sOtherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("AccessControlRequest: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.sReferenceId != null) {
            ++numFields;
        }
        if (this.sOtherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.sReferenceId != null) {
            fields[x++] = this.sReferenceId.berEncode();
        }
        fields[x++] = this.sSecurityChallenge.berEncode();
        if (this.sOtherInfo != null) {
            fields[x] = this.sOtherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.sReferenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.sReferenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("securityChallenge ");
        str.append((Object)this.sSecurityChallenge);
        ++outputted;
        if (this.sOtherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.sOtherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

