/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AccessControlResponseSecurityChallengeResponse;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;

public final class AccessControlResponse
extends ASN1Any {
    public ReferenceId referenceId;
    public AccessControlResponseSecurityChallengeResponse securityChallengeResponse;
    public DiagRec diagRec;
    public OtherInformation otherInformation;

    public AccessControlResponse(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("AccessControlResponse: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.referenceId = null;
        this.securityChallengeResponse = null;
        this.diagRec = null;
        this.otherInformation = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.securityChallengeResponse = new AccessControlResponseSecurityChallengeResponse(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.securityChallengeResponse = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 223 && p.getTagType() == 128) {
            BERConstructed tagged;
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("AccessControlResponse: bad BER encoding: s_diagnostic tag bad\n");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("AccessControlResponse: bad BER encoding: s_diagnostic tag bad\n");
            }
            this.diagRec = new DiagRec(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInformation = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInformation = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("AccessControlResponse: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 0;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.securityChallengeResponse != null) {
            ++numFields;
        }
        if (this.diagRec != null) {
            ++numFields;
        }
        if (this.otherInformation != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        if (this.securityChallengeResponse != null) {
            fields[x++] = this.securityChallengeResponse.berEncode();
        }
        if (this.diagRec != null) {
            BEREncoding[] enc = new BEREncoding[]{this.diagRec.berEncode()};
            fields[x++] = new BERConstructed(128, 223, enc);
        }
        if (this.otherInformation != null) {
            fields[x] = this.otherInformation.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (this.securityChallengeResponse != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("securityChallengeResponse ");
            str.append((Object)this.securityChallengeResponse);
            ++outputted;
        }
        if (this.diagRec != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("diagnostic ");
            str.append((Object)this.diagRec);
            ++outputted;
        }
        if (this.otherInformation != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInformation);
        }
        str.append("}");
        return str.toString();
    }
}

