/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.StringOrNumeric;

public final class AttributeElementAttributeValueComplex
extends ASN1Any {
    public StringOrNumeric[] list;
    public ASN1Integer[] semanticAction;

    public AttributeElementAttributeValueComplex(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        int n;
        int parts;
        BERConstructed cons;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("AttributeElement_attributeValue_complex: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("AttributeElement_attributeValue_complex: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("AttributeElement_attributeValue_complex: bad tag in s_list\n");
        }
        try {
            cons = (BERConstructed)p;
            parts = cons.numberComponents();
            this.list = new StringOrNumeric[parts];
            for (n = 0; n < parts; ++n) {
                this.list[n] = new StringOrNumeric(cons.elementAt(n), true);
            }
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("Bad BER");
        }
        this.semanticAction = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            try {
                cons = (BERConstructed)p;
                parts = cons.numberComponents();
                this.semanticAction = new ASN1Integer[parts];
                for (n = 0; n < parts; ++n) {
                    this.semanticAction[n] = new ASN1Integer(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("AttributeElement_attributeValue_complex: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int p;
        int numFields = 1;
        if (this.semanticAction != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        BEREncoding[] f2 = new BEREncoding[this.list.length];
        for (p = 0; p < this.list.length; ++p) {
            f2[p] = this.list[p].berEncode();
        }
        fields[x++] = new BERConstructed(128, 1, f2);
        if (this.semanticAction != null) {
            f2 = new BEREncoding[this.semanticAction.length];
            for (p = 0; p < this.semanticAction.length; ++p) {
                f2[p] = this.semanticAction[p].berEncode();
            }
            fields[x] = new BERConstructed(128, 2, f2);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        int p;
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("list ");
        str.append("{");
        for (p = 0; p < this.list.length; ++p) {
            if (p != 0) {
                str.append(", ");
            }
            str.append((Object)this.list[p]);
        }
        str.append("}");
        ++outputted;
        if (this.semanticAction != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("semanticAction ");
            str.append("{");
            for (p = 0; p < this.semanticAction.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append(this.semanticAction[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

