/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.AttributeElement;

public final class AttributeList
extends ASN1Any {
    public AttributeElement[] value;

    public AttributeList() {
    }

    public AttributeList(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        if (checkTag && (ber.getTag() != 44 || ber.getTagType() != 128)) {
            throw new ASN1EncodingException("AttributeList: bad BER: tag=" + ber.getTag() + " expected 44\n");
        }
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("AttributeList: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        this.value = new AttributeElement[numParts];
        for (int p = 0; p < numParts; ++p) {
            this.value[p] = new AttributeElement(berConstructed.elementAt(p), true);
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(128, 44);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BERConstructed[] fields = new BERConstructed[this.value.length];
        for (int p = 0; p < this.value.length; ++p) {
            fields[p] = this.value[p].berEncode();
        }
        return new BERConstructed(tagType, tag, (BEREncoding[])fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        for (int p = 0; p < this.value.length; ++p) {
            str.append((Object)this.value[p]);
        }
        str.append("}");
        return str.toString();
    }
}

