/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.CompSpecDbSpecific;
import org.xbib.z3950.common.v3.Specification;

public final class CompSpec
extends ASN1Any {
    public ASN1Boolean selectAlternativeSyntax;
    public Specification sGeneric;
    public CompSpecDbSpecific[] dbSpecifics;
    public ASN1ObjectIdentifier[] recordSyntax;

    public CompSpec() {
    }

    public CompSpec(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        int n;
        int parts;
        BERConstructed cons;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("CompSpec: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("CompSpec: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() != 1 || p.getTagType() != 128) {
            throw new ASN1EncodingException("CompSpec: bad tag in s_selectAlternativeSyntax\n");
        }
        this.selectAlternativeSyntax = new ASN1Boolean(p, false);
        this.sGeneric = null;
        this.dbSpecifics = null;
        this.recordSyntax = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            this.sGeneric = new Specification(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 3 && p.getTagType() == 128) {
            try {
                cons = (BERConstructed)p;
                parts = cons.numberComponents();
                this.dbSpecifics = new CompSpecDbSpecific[parts];
                for (n = 0; n < parts; ++n) {
                    this.dbSpecifics[n] = new CompSpecDbSpecific(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 4 && p.getTagType() == 128) {
            try {
                cons = (BERConstructed)p;
                parts = cons.numberComponents();
                this.recordSyntax = new ASN1ObjectIdentifier[parts];
                for (n = 0; n < parts; ++n) {
                    this.recordSyntax[n] = new ASN1ObjectIdentifier(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("CompSpec: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int p;
        BEREncoding[] f2;
        int numFields = 1;
        if (this.sGeneric != null) {
            ++numFields;
        }
        if (this.dbSpecifics != null) {
            ++numFields;
        }
        if (this.recordSyntax != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.selectAlternativeSyntax.berEncode(128, 1);
        if (this.sGeneric != null) {
            fields[x++] = this.sGeneric.berEncode(128, 2);
        }
        if (this.dbSpecifics != null) {
            f2 = new BEREncoding[this.dbSpecifics.length];
            for (p = 0; p < this.dbSpecifics.length; ++p) {
                f2[p] = this.dbSpecifics[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 3, f2);
        }
        if (this.recordSyntax != null) {
            f2 = new BEREncoding[this.recordSyntax.length];
            for (p = 0; p < this.recordSyntax.length; ++p) {
                f2[p] = this.recordSyntax[p].berEncode();
            }
            fields[x] = new BERConstructed(128, 4, f2);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        int p;
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("selectAlternativeSyntax ");
        str.append(this.selectAlternativeSyntax);
        ++outputted;
        if (this.sGeneric != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("generic ");
            str.append((Object)this.sGeneric);
            ++outputted;
        }
        if (this.dbSpecifics != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("dbSpecific ");
            str.append("{");
            for (p = 0; p < this.dbSpecifics.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.dbSpecifics[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.recordSyntax != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("recordSyntax ");
            str.append("{");
            for (p = 0; p < this.recordSyntax.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append(this.recordSyntax[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

