/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DefaultDiagFormatAddinfo;

public final class DefaultDiagFormat
extends ASN1Any {
    public ASN1ObjectIdentifier diagnosticSetId;
    public ASN1Integer condition;
    public DefaultDiagFormatAddinfo addinfo;

    public DefaultDiagFormat(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.diagnosticSetId = new ASN1ObjectIdentifier(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.condition = new ASN1Integer(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.addinfo = new DefaultDiagFormatAddinfo(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.diagnosticSetId.berEncode();
        fields[x++] = this.condition.berEncode();
        fields[x] = this.addinfo.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("diagnosticSetId ");
        str.append(this.diagnosticSetId);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("condition ");
        str.append(this.condition);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("addinfo ");
        str.append((Object)this.addinfo);
        str.append("}");
        return str.toString();
    }
}

