/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResultSetId;

public final class DeleteResultSetRequest
extends ASN1Any {
    public static final int E_LIST = 0;
    public static final int E_ALL = 1;
    public ReferenceId referenceId;
    public ASN1Integer sDeleteFunction;
    public ResultSetId[] sResultSetList;
    public OtherInformation sOtherInfo;

    public DeleteResultSetRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 32 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_deleteFunction");
        }
        this.sDeleteFunction = new ASN1Integer(p, false);
        this.sResultSetList = null;
        this.sOtherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            try {
                BERConstructed cons = (BERConstructed)p;
                int parts = cons.numberComponents();
                this.sResultSetList = new ResultSetId[parts];
                for (int n = 0; n < parts; ++n) {
                    this.sResultSetList[n] = new ResultSetId(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER");
            }
            ++part;
        }
        catch (ASN1Exception e) {
            this.sResultSetList = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sOtherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sOtherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.sResultSetList != null) {
            ++numFields;
        }
        if (this.sOtherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.sDeleteFunction.berEncode(128, 32);
        if (this.sResultSetList != null) {
            BEREncoding[] f2 = new BEREncoding[this.sResultSetList.length];
            for (int p = 0; p < this.sResultSetList.length; ++p) {
                f2[p] = this.sResultSetList[p].berEncode();
            }
            fields[x++] = new BERConstructed(0, 16, f2);
        }
        if (this.sOtherInfo != null) {
            fields[x] = this.sOtherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("deleteFunction ");
        str.append(this.sDeleteFunction);
        ++outputted;
        if (this.sResultSetList != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("resultSetList ");
            str.append("{");
            for (int p = 0; p < this.sResultSetList.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.sResultSetList[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.sOtherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.sOtherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

