/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DefaultDiagFormat;

public final class DiagRec
extends ASN1Any {
    public DefaultDiagFormat defaultFormat;
    public ASN1External externallyDefined;

    public DiagRec(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.defaultFormat = null;
        this.externallyDefined = null;
        try {
            this.defaultFormat = new DefaultDiagFormat(ber, checkTag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.externallyDefined = new ASN1External(ber, checkTag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                throw new ASN1Exception("bad BER encoding: choice not matched");
            }
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.defaultFormat != null) {
            chosen = this.defaultFormat.berEncode();
        }
        if (this.externallyDefined != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.externallyDefined.berEncode();
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.defaultFormat != null) {
            found = true;
            str.append("defaultFormat ");
            str.append((Object)this.defaultFormat);
        }
        if (this.externallyDefined != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: externallyDefined> ");
            }
            str.append("externallyDefined ");
            str.append(this.externallyDefined);
        }
        str.append("}");
        return str.toString();
    }
}

