/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.ElementSetNamesDatabaseSpecific;
import org.xbib.z3950.common.v3.InternationalString;

public final class ElementSetNames
extends ASN1Any {
    public InternationalString cGenericElementSetName;
    public ElementSetNamesDatabaseSpecific[] cDatabaseSpecific;

    public ElementSetNames() {
    }

    public ElementSetNames(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.cGenericElementSetName = null;
        this.cDatabaseSpecific = null;
        if (ber.getTag() == 0 && ber.getTagType() == 128) {
            this.cGenericElementSetName = new InternationalString(ber, false);
            return;
        }
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            BERConstructed berConstructed;
            BEREncoding berData = ber;
            try {
                berConstructed = (BERConstructed)berData;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            int numParts = berConstructed.numberComponents();
            this.cDatabaseSpecific = new ElementSetNamesDatabaseSpecific[numParts];
            for (int p = 0; p < numParts; ++p) {
                this.cDatabaseSpecific[p] = new ElementSetNamesDatabaseSpecific(berConstructed.elementAt(p), true);
            }
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.cGenericElementSetName != null) {
            chosen = this.cGenericElementSetName.berEncode(128, 0);
        }
        if (this.cDatabaseSpecific != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] f2 = new BEREncoding[this.cDatabaseSpecific.length];
            for (int p = 0; p < this.cDatabaseSpecific.length; ++p) {
                f2[p] = this.cDatabaseSpecific[p].berEncode();
            }
            chosen = new BERConstructed(128, 1, f2);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.cGenericElementSetName != null) {
            found = true;
            str.append("genericElementSetName ");
            str.append((Object)this.cGenericElementSetName);
        }
        if (this.cDatabaseSpecific != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: databaseSpecific> ");
            }
            str.append("databaseSpecific ");
            str.append("{");
            for (int p = 0; p < this.cDatabaseSpecific.length; ++p) {
                str.append((Object)this.cDatabaseSpecific[p]);
            }
            str.append("}");
        }
        str.append("}");
        return str.toString();
    }
}

