/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.DiagRec;
import org.xbib.z3950.common.v3.TermInfo;

public final class Entry
extends ASN1Any {
    public TermInfo cTermInfo;
    public DiagRec cSurrogateDiagnostic;

    public Entry(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.cTermInfo = null;
        this.cSurrogateDiagnostic = null;
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.cTermInfo = new TermInfo(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.cSurrogateDiagnostic = new DiagRec(tagwrapper.elementAt(0), true);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.cTermInfo != null) {
            chosen = this.cTermInfo.berEncode(128, 1);
        }
        if (this.cSurrogateDiagnostic != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] enc = new BEREncoding[]{this.cSurrogateDiagnostic.berEncode()};
            chosen = new BERConstructed(128, 2, enc);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.cTermInfo != null) {
            found = true;
            str.append("termInfo ");
            str.append((Object)this.cTermInfo);
        }
        if (this.cSurrogateDiagnostic != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: surrogateDiagnostic> ");
            }
            str.append("surrogateDiagnostic ");
            str.append((Object)this.cSurrogateDiagnostic);
        }
        str.append("}");
        return str.toString();
    }
}

