/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.ElementSetName;
import org.xbib.z3950.common.v3.IntUnit;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.Permissions;
import org.xbib.z3950.common.v3.ReferenceId;

public final class ExtendedServicesRequest
extends ASN1Any {
    public static final int E_CREATE = 1;
    public static final int E_DELETE = 2;
    public static final int E_MODIFY = 3;
    public static final int E_WAIT = 1;
    public static final int E_WAIT_IF_POSSIBLE = 2;
    public static final int E_DONT_WAIT = 3;
    public static final int E_DONT_RETURN_PACKAGE = 4;
    public ReferenceId sReferenceId;
    public ASN1Integer sFunction;
    public ASN1ObjectIdentifier sPackageType;
    public InternationalString sPackageName;
    public InternationalString sUserId;
    public IntUnit sRetentionTime;
    public Permissions sPermissions;
    public InternationalString sDescription;
    public ASN1External sTaskSpecificParameters;
    public ASN1Integer sWaitAction;
    public ElementSetName sElements;
    public OtherInformation sOtherInfo;

    public ExtendedServicesRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.sReferenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sReferenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_function");
        }
        this.sFunction = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 4 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in s_packageType");
        }
        this.sPackageType = new ASN1ObjectIdentifier(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 5 && p.getTagType() == 128) {
            this.sPackageName = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 6 && p.getTagType() == 128) {
            this.sUserId = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 7 && p.getTagType() == 128) {
            this.sRetentionTime = new IntUnit(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 8 && p.getTagType() == 128) {
            this.sPermissions = new Permissions(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 9 && p.getTagType() == 128) {
            this.sDescription = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 10 && p.getTagType() == 128) {
            this.sTaskSpecificParameters = new ASN1External(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 11 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in waitAction");
        }
        this.sWaitAction = new ASN1Integer(p, false);
        this.sElements = null;
        this.sOtherInfo = null;
        if (numParts <= ++part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sElements = new ElementSetName(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sElements = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.sOtherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.sOtherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        if (this.sReferenceId != null) {
            ++numFields;
        }
        if (this.sPackageName != null) {
            ++numFields;
        }
        if (this.sUserId != null) {
            ++numFields;
        }
        if (this.sRetentionTime != null) {
            ++numFields;
        }
        if (this.sPermissions != null) {
            ++numFields;
        }
        if (this.sDescription != null) {
            ++numFields;
        }
        if (this.sTaskSpecificParameters != null) {
            ++numFields;
        }
        if (this.sElements != null) {
            ++numFields;
        }
        if (this.sOtherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.sReferenceId != null) {
            fields[x++] = this.sReferenceId.berEncode();
        }
        fields[x++] = this.sFunction.berEncode(128, 3);
        fields[x++] = this.sPackageType.berEncode(128, 4);
        if (this.sPackageName != null) {
            fields[x++] = this.sPackageName.berEncode(128, 5);
        }
        if (this.sUserId != null) {
            fields[x++] = this.sUserId.berEncode(128, 6);
        }
        if (this.sRetentionTime != null) {
            fields[x++] = this.sRetentionTime.berEncode(128, 7);
        }
        if (this.sPermissions != null) {
            fields[x++] = this.sPermissions.berEncode(128, 8);
        }
        if (this.sDescription != null) {
            fields[x++] = this.sDescription.berEncode(128, 9);
        }
        if (this.sTaskSpecificParameters != null) {
            fields[x++] = this.sTaskSpecificParameters.berEncode(128, 10);
        }
        fields[x++] = this.sWaitAction.berEncode(128, 11);
        if (this.sElements != null) {
            fields[x++] = this.sElements.berEncode();
        }
        if (this.sOtherInfo != null) {
            fields[x] = this.sOtherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.sReferenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.sReferenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("function ");
        str.append(this.sFunction);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("packageType ");
        str.append(this.sPackageType);
        ++outputted;
        if (this.sPackageName != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("packageName ");
            str.append((Object)this.sPackageName);
            ++outputted;
        }
        if (this.sUserId != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("userId ");
            str.append((Object)this.sUserId);
            ++outputted;
        }
        if (this.sRetentionTime != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("retentionTime ");
            str.append((Object)this.sRetentionTime);
            ++outputted;
        }
        if (this.sPermissions != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("permissions ");
            str.append((Object)this.sPermissions);
            ++outputted;
        }
        if (this.sDescription != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("description ");
            str.append((Object)this.sDescription);
            ++outputted;
        }
        if (this.sTaskSpecificParameters != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("taskSpecificParameters ");
            str.append(this.sTaskSpecificParameters);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("waitAction ");
        str.append(this.sWaitAction);
        ++outputted;
        if (this.sElements != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("elements ");
            str.append((Object)this.sElements);
            ++outputted;
        }
        if (this.sOtherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.sOtherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

