/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1OctetString;
import org.xbib.asn1.BEREncoding;

public final class FragmentSyntax
extends ASN1Any {
    public ASN1External c_externallyTagged;
    public ASN1OctetString c_notExternallyTagged;

    public FragmentSyntax(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.c_externallyTagged = null;
        this.c_notExternallyTagged = null;
        try {
            this.c_externallyTagged = new ASN1External(ber, checkTag);
            return;
        }
        catch (ASN1Exception aSN1Exception) {
            try {
                this.c_notExternallyTagged = new ASN1OctetString(ber, checkTag);
                return;
            }
            catch (ASN1Exception aSN1Exception2) {
                throw new ASN1Exception("FragmentSyntax: bad BER encoding: choice not matched");
            }
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.c_externallyTagged != null) {
            chosen = this.c_externallyTagged.berEncode();
        }
        if (this.c_notExternallyTagged != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.c_notExternallyTagged.berEncode();
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.c_externallyTagged != null) {
            found = true;
            str.append("externallyTagged ");
            str.append(this.c_externallyTagged);
        }
        if (this.c_notExternallyTagged != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: notExternallyTagged> ");
            }
            str.append("notExternallyTagged ");
            str.append(this.c_notExternallyTagged);
        }
        str.append("}");
        return str.toString();
    }
}

