/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InternationalString;

public final class IdAuthenticationIdPass
extends ASN1Any {
    public InternationalString s_groupId;
    public InternationalString s_userId;
    public InternationalString s_password;

    public IdAuthenticationIdPass() {
    }

    public IdAuthenticationIdPass(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("IdAuthentication_idPass: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        this.s_groupId = null;
        this.s_userId = null;
        this.s_password = null;
        if (numParts <= part) {
            return;
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 0 && p.getTagType() == 128) {
            this.s_groupId = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.s_userId = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 2 && p.getTagType() == 128) {
            this.s_password = new InternationalString(p, false);
            ++part;
        }
        if (part < numParts) {
            throw new ASN1Exception("IdAuthentication_idPass: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 0;
        if (this.s_groupId != null) {
            ++numFields;
        }
        if (this.s_userId != null) {
            ++numFields;
        }
        if (this.s_password != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_groupId != null) {
            fields[x++] = this.s_groupId.berEncode(128, 0);
        }
        if (this.s_userId != null) {
            fields[x++] = this.s_userId.berEncode(128, 1);
        }
        if (this.s_password != null) {
            fields[x] = this.s_password.berEncode(128, 2);
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_groupId != null) {
            str.append("groupId ");
            str.append((Object)this.s_groupId);
            ++outputted;
        }
        if (this.s_userId != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("userId ");
            str.append((Object)this.s_userId);
            ++outputted;
        }
        if (this.s_password != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("password ");
            str.append((Object)this.s_password);
        }
        str.append("}");
        return str.toString();
    }
}

