/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1External;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.IdAuthentication;
import org.xbib.z3950.common.v3.InternationalString;
import org.xbib.z3950.common.v3.Options;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.ProtocolVersion;
import org.xbib.z3950.common.v3.ReferenceId;

public final class InitializeRequest
extends ASN1Any {
    public ReferenceId referenceId;
    public ProtocolVersion protocolVersion;
    public Options options;
    public ASN1Integer preferredMessageSize;
    public ASN1Integer exceptionalRecordSize;
    public IdAuthentication idAuthentication;
    public InternationalString implementationId;
    public InternationalString implementationName;
    public InternationalString implementationVersion;
    public ASN1External userInformationField;
    public OtherInformation otherInfo;

    public InitializeRequest() {
    }

    public InitializeRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.protocolVersion = new ProtocolVersion(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.options = new Options(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 5 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in preferredMessageSize");
        }
        this.preferredMessageSize = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 6 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in exceptionalRecordSize");
        }
        this.exceptionalRecordSize = new ASN1Integer(p, false);
        ++part;
        this.idAuthentication = null;
        this.implementationId = null;
        this.implementationName = null;
        this.implementationVersion = null;
        this.userInformationField = null;
        this.otherInfo = null;
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 7 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: idAuthentication tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: idAuthentication tag bad");
            }
            this.idAuthentication = new IdAuthentication(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 110 && p.getTagType() == 128) {
            this.implementationId = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 111 && p.getTagType() == 128) {
            this.implementationName = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 112 && p.getTagType() == 128) {
            this.implementationVersion = new InternationalString(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 11 && p.getTagType() == 128) {
            try {
                tagged = (BERConstructed)p;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER encoding: s_userInformationField tag bad");
            }
            if (tagged.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER encoding: s_userInformationField tag bad");
            }
            this.userInformationField = new ASN1External(tagged.elementAt(0), true);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BEREncoding[] enc;
        int numFields = 4;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.idAuthentication != null) {
            ++numFields;
        }
        if (this.implementationId != null) {
            ++numFields;
        }
        if (this.implementationName != null) {
            ++numFields;
        }
        if (this.implementationVersion != null) {
            ++numFields;
        }
        if (this.userInformationField != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.protocolVersion.berEncode();
        fields[x++] = this.options.berEncode();
        fields[x++] = this.preferredMessageSize.berEncode(128, 5);
        fields[x++] = this.exceptionalRecordSize.berEncode(128, 6);
        if (this.idAuthentication != null) {
            enc = new BEREncoding[]{this.idAuthentication.berEncode()};
            fields[x++] = new BERConstructed(128, 7, enc);
        }
        if (this.implementationId != null) {
            fields[x++] = this.implementationId.berEncode(128, 110);
        }
        if (this.implementationName != null) {
            fields[x++] = this.implementationName.berEncode(128, 111);
        }
        if (this.implementationVersion != null) {
            fields[x++] = this.implementationVersion.berEncode(128, 112);
        }
        if (this.userInformationField != null) {
            enc = new BEREncoding[]{this.userInformationField.berEncode()};
            fields[x++] = new BERConstructed(128, 11, enc);
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("protocolVersion ");
        str.append((Object)this.protocolVersion);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("options ");
        str.append((Object)this.options);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("preferredMessageSize ");
        str.append(this.preferredMessageSize);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("exceptionalRecordSize ");
        str.append(this.exceptionalRecordSize);
        ++outputted;
        if (this.idAuthentication != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("idAuthentication ");
            str.append((Object)this.idAuthentication);
            ++outputted;
        }
        if (this.implementationId != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("implementationId ");
            str.append((Object)this.implementationId);
            ++outputted;
        }
        if (this.implementationName != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("implementationName ");
            str.append((Object)this.implementationName);
            ++outputted;
        }
        if (this.implementationVersion != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("implementationVersion ");
            str.append((Object)this.implementationVersion);
            ++outputted;
        }
        if (this.userInformationField != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("userInformationField ");
            str.append(this.userInformationField);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

