/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Null;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.ProximityOperator;

public final class Operator
extends ASN1Any {
    public ASN1Null andOp;
    public ASN1Null orOp;
    public ASN1Null andNotOp;
    public ProximityOperator proxOp;

    public Operator() {
    }

    public Operator(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagwrapper;
        if (checkTag && (ber.getTag() != 46 || ber.getTagType() != 128)) {
            throw new ASN1EncodingException("bad BER: tag=" + ber.getTag() + " expected 46");
        }
        try {
            tagwrapper = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER tag form");
        }
        if (tagwrapper.numberComponents() != 1) {
            throw new ASN1EncodingException("bad BER tag form");
        }
        ber = tagwrapper.elementAt(0);
        this.andOp = null;
        this.orOp = null;
        this.andNotOp = null;
        this.proxOp = null;
        if (ber.getTag() == 0 && ber.getTagType() == 128) {
            this.andOp = new ASN1Null(ber, false);
            return;
        }
        if (ber.getTag() == 1 && ber.getTagType() == 128) {
            this.orOp = new ASN1Null(ber, false);
            return;
        }
        if (ber.getTag() == 2 && ber.getTagType() == 128) {
            this.andNotOp = new ASN1Null(ber, false);
            return;
        }
        if (ber.getTag() == 3 && ber.getTagType() == 128) {
            this.proxOp = new ProximityOperator(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(128, 46);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.andOp != null) {
            chosen = this.andOp.berEncode(128, 0);
        }
        if (this.orOp != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.orOp.berEncode(128, 1);
        }
        if (this.andNotOp != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.andNotOp.berEncode(128, 2);
        }
        if (this.proxOp != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.proxOp.berEncode(128, 3);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        BEREncoding[] exp_tag_data = new BEREncoding[]{chosen};
        return new BERConstructed(tagType, tag, exp_tag_data);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.andOp != null) {
            found = true;
            str.append("and ");
            str.append(this.andOp);
        }
        if (this.orOp != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: or> ");
            }
            found = true;
            str.append("or ");
            str.append(this.orOp);
        }
        if (this.andNotOp != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: and-not> ");
            }
            found = true;
            str.append("and-not ");
            str.append(this.andNotOp);
        }
        if (this.proxOp != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: prox> ");
            }
            str.append("prox ");
            str.append((Object)this.proxOp);
        }
        str.append("}");
        return str.toString();
    }
}

