/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.InfoCategory;
import org.xbib.z3950.common.v3.OtherInformationInformation;

public final class OtherInformation1
extends ASN1Any {
    public InfoCategory category;
    public OtherInformationInformation information;

    public OtherInformation1(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("OtherInformation1: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("OtherInformation1: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.category = new InfoCategory(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("OtherInformation1: incomplete");
        }
        p = berConstructed.elementAt(part);
        this.information = new OtherInformationInformation(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("OtherInformation1: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 1;
        if (this.category != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.category != null) {
            fields[x++] = this.category.berEncode(128, 1);
        }
        fields[x] = this.information.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.category != null) {
            str.append("category ");
            str.append((Object)this.category);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("information ");
        str.append((Object)this.information);
        str.append("}");
        return str.toString();
    }
}

