/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.ASN1ObjectIdentifier;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.OtherInformation;
import org.xbib.z3950.common.v3.PresentRequestRecordComposition;
import org.xbib.z3950.common.v3.Range;
import org.xbib.z3950.common.v3.ReferenceId;
import org.xbib.z3950.common.v3.ResultSetId;

public final class PresentRequest
extends ASN1Any {
    public ReferenceId referenceId;
    public ResultSetId resultSetId;
    public ASN1Integer resultSetStartPoint;
    public ASN1Integer numberOfRecordsRequested;
    public Range[] additionalRanges;
    public PresentRequestRecordComposition recordComposition;
    public ASN1ObjectIdentifier preferredRecordSyntax;
    public ASN1Integer maxSegmentCount;
    public ASN1Integer maxRecordSize;
    public ASN1Integer maxSegmentSize;
    public OtherInformation otherInfo;

    public PresentRequest() {
    }

    public PresentRequest(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        try {
            this.referenceId = new ReferenceId(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.referenceId = null;
        }
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.resultSetId = new ResultSetId(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 30 || p.getTagType() != 128) {
            throw new ASN1EncodingException("bad tag in resultSetStartPoint\n");
        }
        this.resultSetStartPoint = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 29 || p.getTagType() != 128) {
            throw new ASN1EncodingException("PresentRequest: bad tag in numberOfRecordsRequested");
        }
        this.numberOfRecordsRequested = new ASN1Integer(p, false);
        ++part;
        this.additionalRanges = null;
        this.recordComposition = null;
        this.preferredRecordSyntax = null;
        this.maxSegmentCount = null;
        this.maxRecordSize = null;
        this.maxSegmentSize = null;
        this.otherInfo = null;
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 212 && p.getTagType() == 128) {
            try {
                BERConstructed cons = (BERConstructed)p;
                int parts = cons.numberComponents();
                this.additionalRanges = new Range[parts];
                for (int n = 0; n < parts; ++n) {
                    this.additionalRanges[n] = new Range(cons.elementAt(n), true);
                }
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER");
            }
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.recordComposition = new PresentRequestRecordComposition(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.recordComposition = null;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 104 && p.getTagType() == 128) {
            this.preferredRecordSyntax = new ASN1ObjectIdentifier(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 204 && p.getTagType() == 128) {
            this.maxSegmentCount = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 206 && p.getTagType() == 128) {
            this.maxRecordSize = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() == 207 && p.getTagType() == 128) {
            this.maxSegmentSize = new ASN1Integer(p, false);
            ++part;
        }
        if (numParts <= part) {
            return;
        }
        p = berConstructed.elementAt(part);
        try {
            this.otherInfo = new OtherInformation(p, true);
            ++part;
        }
        catch (ASN1Exception e) {
            this.otherInfo = null;
        }
        if (part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        if (this.referenceId != null) {
            ++numFields;
        }
        if (this.additionalRanges != null) {
            ++numFields;
        }
        if (this.recordComposition != null) {
            ++numFields;
        }
        if (this.preferredRecordSyntax != null) {
            ++numFields;
        }
        if (this.maxSegmentCount != null) {
            ++numFields;
        }
        if (this.maxRecordSize != null) {
            ++numFields;
        }
        if (this.maxSegmentSize != null) {
            ++numFields;
        }
        if (this.otherInfo != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.referenceId != null) {
            fields[x++] = this.referenceId.berEncode();
        }
        fields[x++] = this.resultSetId.berEncode();
        fields[x++] = this.resultSetStartPoint.berEncode(128, 30);
        fields[x++] = this.numberOfRecordsRequested.berEncode(128, 29);
        if (this.additionalRanges != null) {
            BEREncoding[] f2 = new BEREncoding[this.additionalRanges.length];
            for (int p = 0; p < this.additionalRanges.length; ++p) {
                f2[p] = this.additionalRanges[p].berEncode();
            }
            fields[x++] = new BERConstructed(128, 212, f2);
        }
        if (this.recordComposition != null) {
            fields[x++] = this.recordComposition.berEncode();
        }
        if (this.preferredRecordSyntax != null) {
            fields[x++] = this.preferredRecordSyntax.berEncode(128, 104);
        }
        if (this.maxSegmentCount != null) {
            fields[x++] = this.maxSegmentCount.berEncode(128, 204);
        }
        if (this.maxRecordSize != null) {
            fields[x++] = this.maxRecordSize.berEncode(128, 206);
        }
        if (this.maxSegmentSize != null) {
            fields[x++] = this.maxSegmentSize.berEncode(128, 207);
        }
        if (this.otherInfo != null) {
            fields[x] = this.otherInfo.berEncode();
        }
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.referenceId != null) {
            str.append("referenceId ");
            str.append((Object)this.referenceId);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("resultSetId ");
        str.append((Object)this.resultSetId);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("resultSetStartPoint ");
        str.append(this.resultSetStartPoint);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("numberOfRecordsRequested ");
        str.append(this.numberOfRecordsRequested);
        ++outputted;
        if (this.additionalRanges != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("additionalRanges ");
            str.append("{");
            for (int p = 0; p < this.additionalRanges.length; ++p) {
                if (p != 0) {
                    str.append(", ");
                }
                str.append((Object)this.additionalRanges[p]);
            }
            str.append("}");
            ++outputted;
        }
        if (this.recordComposition != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("recordComposition ");
            str.append((Object)this.recordComposition);
            ++outputted;
        }
        if (this.preferredRecordSyntax != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("preferredRecordSyntax ");
            str.append(this.preferredRecordSyntax);
            ++outputted;
        }
        if (this.maxSegmentCount != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("maxSegmentCount ");
            str.append(this.maxSegmentCount);
            ++outputted;
        }
        if (this.maxRecordSize != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("maxRecordSize ");
            str.append(this.maxRecordSize);
            ++outputted;
        }
        if (this.maxSegmentSize != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("maxSegmentSize ");
            str.append(this.maxSegmentSize);
            ++outputted;
        }
        if (this.otherInfo != null) {
            if (0 < outputted) {
                str.append(", ");
            }
            str.append("otherInfo ");
            str.append((Object)this.otherInfo);
        }
        str.append("}");
        return str.toString();
    }
}

