/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.CompSpec;
import org.xbib.z3950.common.v3.ElementSetNames;

public final class PresentRequestRecordComposition
extends ASN1Any {
    public ElementSetNames simple;
    public CompSpec complex;

    public PresentRequestRecordComposition() {
    }

    public PresentRequestRecordComposition(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        this.simple = null;
        this.complex = null;
        if (ber.getTag() == 19 && ber.getTagType() == 128) {
            BERConstructed tagwrapper;
            try {
                tagwrapper = (BERConstructed)ber;
            }
            catch (ClassCastException e) {
                throw new ASN1EncodingException("bad BER form");
            }
            if (tagwrapper.numberComponents() != 1) {
                throw new ASN1EncodingException("bad BER form");
            }
            this.simple = new ElementSetNames(tagwrapper.elementAt(0), true);
            return;
        }
        if (ber.getTag() == 209 && ber.getTagType() == 128) {
            this.complex = new CompSpec(ber, false);
            return;
        }
        throw new ASN1Exception("bad BER encoding: choice not matched");
    }

    public BEREncoding berEncode() throws ASN1Exception {
        BEREncoding chosen = null;
        if (this.simple != null) {
            BEREncoding[] enc = new BEREncoding[]{this.simple.berEncode()};
            chosen = new BERConstructed(128, 19, enc);
        }
        if (this.complex != null) {
            if (chosen != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            chosen = this.complex.berEncode(128, 209);
        }
        if (chosen == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return chosen;
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        throw new ASN1EncodingException("cannot implicitly tag");
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        boolean found = false;
        if (this.simple != null) {
            found = true;
            str.append("simple ");
            str.append((Object)this.simple);
        }
        if (this.complex != null) {
            if (found) {
                str.append("<ERROR: multiple CHOICE: complex> ");
            }
            str.append("complex ");
            str.append((Object)this.complex);
        }
        str.append("}");
        return str.toString();
    }
}

