/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1Boolean;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.ASN1Integer;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.ProximityOperatorProximityUnitCode;

public final class ProximityOperator
extends ASN1Any {
    public static final int E_lessThan = 1;
    public static final int E_lessThanOrEqual = 2;
    public static final int E_equal = 3;
    public static final int E_greaterThanOrEqual = 4;
    public static final int E_greaterThan = 5;
    public static final int E_notEqual = 6;
    public ASN1Boolean s_exclusion;
    public ASN1Integer s_distance;
    public ASN1Boolean s_ordered;
    public ASN1Integer s_relationType;
    public ProximityOperatorProximityUnitCode s_proximityUnitCode;

    public ProximityOperator(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed tagged;
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("ProximityOperator: bad BER form\n");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("ProximityOperator: incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        if (p.getTag() == 1 && p.getTagType() == 128) {
            this.s_exclusion = new ASN1Boolean(p, false);
            ++part;
        }
        if (numParts <= part) {
            throw new ASN1Exception("ProximityOperator: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 2 || p.getTagType() != 128) {
            throw new ASN1EncodingException("ProximityOperator: bad tag in s_distance\n");
        }
        this.s_distance = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("ProximityOperator: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 3 || p.getTagType() != 128) {
            throw new ASN1EncodingException("ProximityOperator: bad tag in s_ordered\n");
        }
        this.s_ordered = new ASN1Boolean(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("ProximityOperator: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 4 || p.getTagType() != 128) {
            throw new ASN1EncodingException("ProximityOperator: bad tag in s_relationType\n");
        }
        this.s_relationType = new ASN1Integer(p, false);
        if (numParts <= ++part) {
            throw new ASN1Exception("ProximityOperator: incomplete");
        }
        p = berConstructed.elementAt(part);
        if (p.getTag() != 5 || p.getTagType() != 128) {
            throw new ASN1EncodingException("ProximityOperator: bad tag in s_proximityUnitCode\n");
        }
        try {
            tagged = (BERConstructed)p;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("ProximityOperator: bad BER encoding: s_proximityUnitCode tag bad\n");
        }
        if (tagged.numberComponents() != 1) {
            throw new ASN1EncodingException("ProximityOperator: bad BER encoding: s_proximityUnitCode tag bad\n");
        }
        this.s_proximityUnitCode = new ProximityOperatorProximityUnitCode(tagged.elementAt(0), true);
        if (++part < numParts) {
            throw new ASN1Exception("ProximityOperator: bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 4;
        if (this.s_exclusion != null) {
            ++numFields;
        }
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        if (this.s_exclusion != null) {
            fields[x++] = this.s_exclusion.berEncode(128, 1);
        }
        fields[x++] = this.s_distance.berEncode(128, 2);
        fields[x++] = this.s_ordered.berEncode(128, 3);
        fields[x++] = this.s_relationType.berEncode(128, 4);
        BEREncoding[] enc = new BEREncoding[]{this.s_proximityUnitCode.berEncode()};
        fields[x] = new BERConstructed(128, 5, enc);
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        if (this.s_exclusion != null) {
            str.append("exclusion ");
            str.append(this.s_exclusion);
            ++outputted;
        }
        if (0 < outputted) {
            str.append(", ");
        }
        str.append("distance ");
        str.append(this.s_distance);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("ordered ");
        str.append(this.s_ordered);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("relationType ");
        str.append(this.s_relationType);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("proximityUnitCode ");
        str.append((Object)this.s_proximityUnitCode);
        str.append("}");
        return str.toString();
    }
}

