/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.z3950.common.v3;

import org.xbib.asn1.ASN1Any;
import org.xbib.asn1.ASN1EncodingException;
import org.xbib.asn1.ASN1Exception;
import org.xbib.asn1.BERConstructed;
import org.xbib.asn1.BEREncoding;
import org.xbib.z3950.common.v3.Operator;
import org.xbib.z3950.common.v3.RPNStructure;

public final class RPNStructureRpnRpnOp
extends ASN1Any {
    public RPNStructure s_rpn1;
    public RPNStructure s_rpn2;
    public Operator s_op;

    public RPNStructureRpnRpnOp() {
    }

    public RPNStructureRpnRpnOp(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        super(ber, checkTag);
    }

    public void berDecode(BEREncoding ber, boolean checkTag) throws ASN1Exception {
        BERConstructed berConstructed;
        try {
            berConstructed = (BERConstructed)ber;
        }
        catch (ClassCastException e) {
            throw new ASN1EncodingException("bad BER form");
        }
        int numParts = berConstructed.numberComponents();
        int part = 0;
        if (numParts <= part) {
            throw new ASN1Exception("incomplete");
        }
        BEREncoding p = berConstructed.elementAt(part);
        this.s_rpn1 = new RPNStructure(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.s_rpn2 = new RPNStructure(p, true);
        if (numParts <= ++part) {
            throw new ASN1Exception("incomplete");
        }
        p = berConstructed.elementAt(part);
        this.s_op = new Operator(p, true);
        if (++part < numParts) {
            throw new ASN1Exception("bad BER: extra data " + part + "/" + numParts + " processed");
        }
    }

    public BEREncoding berEncode() throws ASN1Exception {
        return this.berEncode(0, 16);
    }

    public BEREncoding berEncode(int tagType, int tag) throws ASN1Exception {
        int numFields = 3;
        BEREncoding[] fields = new BEREncoding[numFields];
        int x = 0;
        fields[x++] = this.s_rpn1.berEncode();
        fields[x++] = this.s_rpn2.berEncode();
        fields[x] = this.s_op.berEncode();
        return new BERConstructed(tagType, tag, fields);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        int outputted = 0;
        str.append("rpn1 ");
        str.append((Object)this.s_rpn1);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("rpn2 ");
        str.append((Object)this.s_rpn2);
        if (0 < ++outputted) {
            str.append(", ");
        }
        str.append("op ");
        str.append((Object)this.s_op);
        str.append("}");
        return str.toString();
    }
}

